/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.data;

import jp.sourceforge.qrcode.codec.geom.Point;

public class QRCodeSymbol {
    int version;
    int errorCollectionLevel;
    int maskPattern;
    int dataCapacity;
    boolean[][] matrix;
    int width;
    int height;
    Point[][] alignmentPattern;
    final int[][] numErrorCollectionCode = new int[][]{{7, 10, 13, 17}, {10, 16, 22, 28}, {15, 26, 36, 44}, {20, 36, 52, 64}, {26, 48, 72, 88}, {36, 64, 96, 112}, {40, 72, 108, 130}, {48, 88, 132, 156}, {60, 110, 160, 192}, {72, 130, 192, 224}, {80, 120, 224, 264}, {90, 176, 260, 308}, {104, 198, 288, 352}};
    final int[][] numRSBlocks = new int[][]{{1, 1, 1, 1}, {1, 1, 1, 1}, {1, 1, 2, 2}, {1, 2, 2, 4}, {1, 2, 4, 4}, {2, 4, 4, 4}, {2, 4, 6, 5}, {2, 4, 6, 6}, {2, 5, 8, 8}, {4, 5, 8, 8}, {4, 5, 8, 11}, {4, 8, 10, 11}, {4, 9, 12, 16}};

    public boolean getElement(int x, int y) {
        return this.matrix[x][y];
    }

    public int getNumErrorCollectionCode() {
        return this.numErrorCollectionCode[this.version - 1][this.errorCollectionLevel];
    }

    public int getNumRSBlocks() {
        return this.numRSBlocks[this.version - 1][this.errorCollectionLevel];
    }

    public QRCodeSymbol(boolean[][] matrix) {
        this.matrix = matrix;
        this.width = matrix.length;
        this.height = matrix[0].length;
        this.initialize();
    }

    void initialize() {
        this.version = (this.width - 17) / 4;
        Point[][] alignmentPattern = new Point[1][1];
        int[] logicalSeeds = new int[1];
        if (this.version >= 2 && this.version <= 6) {
            logicalSeeds = new int[]{6, 10 + 4 * this.version};
            alignmentPattern = new Point[logicalSeeds.length][logicalSeeds.length];
        } else if (this.version >= 7 && this.version <= 13) {
            logicalSeeds = new int[]{6, 8 + 2 * this.version, 10 + 4 * this.version};
            alignmentPattern = new Point[logicalSeeds.length][logicalSeeds.length];
        }
        int col = 0;
        while (col < logicalSeeds.length) {
            int row = 0;
            while (row < logicalSeeds.length) {
                alignmentPattern[row][col] = new Point(logicalSeeds[row], logicalSeeds[col]);
                ++row;
            }
            ++col;
        }
        this.alignmentPattern = alignmentPattern;
        this.dataCapacity = this.calcDataCapacity();
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionReference() {
        char[] versionReferenceCharacter = new char[]{'L', 'M', 'Q', 'H'};
        return String.valueOf(Integer.toString(this.version)) + "-" + versionReferenceCharacter[this.errorCollectionLevel];
    }

    public Point[][] getAlignmentPattern() {
        return this.alignmentPattern;
    }

    private int calcDataCapacity() {
        int numFunctionPatternModule = 0;
        int numFormatAndVersionInfoModule = 0;
        int version = this.getVersion();
        if (version == 1) {
            numFunctionPatternModule = 202;
        } else if (version >= 2 && version <= 6) {
            numFunctionPatternModule = 219 + 8 * version;
        } else if (version >= 7 && version <= 13) {
            numFunctionPatternModule = 334 + 8 * version;
        } else if (version >= 14 && version <= 20) {
            numFunctionPatternModule = 499 + 8 * version;
        }
        numFormatAndVersionInfoModule = version <= 6 ? 31 : 67;
        int dataCapacity = (this.width * this.width - numFunctionPatternModule - numFormatAndVersionInfoModule) / 8;
        return dataCapacity;
    }

    public int getDataCapacity() {
        return this.dataCapacity;
    }

    public void setFormatInformation(boolean[] formatInformation) {
        this.errorCollectionLevel = !formatInformation[4] ? (formatInformation[3] ? 0 : 1) : (formatInformation[3] ? 2 : 3);
        int i = 2;
        while (i >= 0) {
            if (formatInformation[i]) {
                this.maskPattern += 1 << i;
            }
            --i;
        }
    }

    public int getErrorCollectionLevel() {
        return this.errorCollectionLevel;
    }

    public int getMaskPatternReferer() {
        return this.maskPattern;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void reverseElement(int x, int y) {
        this.matrix[x][y] = !this.matrix[x][y];
    }

    public boolean isInFunctionPattern(int targetX, int targetY) {
        if (targetX < 9 && targetY < 9) {
            return true;
        }
        if (targetX > this.getWidth() - 9 && targetY < 9) {
            return true;
        }
        if (targetX < 9 && targetY > this.getHeight() - 9) {
            return true;
        }
        if (this.version >= 7) {
            if (targetX > this.getWidth() - 12 && targetY < 6) {
                return true;
            }
            if (targetX < 6 && targetY > this.getHeight() - 12) {
                return true;
            }
        }
        if (targetX == 6 || targetY == 6) {
            return true;
        }
        Point[][] alignmentPattern = this.getAlignmentPattern();
        int sideLength = alignmentPattern.length;
        int y = 0;
        while (y < sideLength) {
            int x = 0;
            while (x < sideLength) {
                if (!(x == 0 && y == 0 || x == sideLength - 1 && y == 0 || x == 0 && y == sideLength - 1 || Math.abs(alignmentPattern[x][y].getX() - targetX) >= 3 || Math.abs(alignmentPattern[x][y].getY() - targetY) >= 3)) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }
}

