/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.eclipse.plugin.proptranslator.util.StringUtils;
import jp.eclipse.plugin.proptranslator.wizard.FileModel;
import jp.eclipse.plugin.proptranslator.wizard.FileSelectLabelProvider;
import jp.eclipse.plugin.proptranslator.wizard.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectWizardPage1
extends WizardPage {
    private CheckboxTableViewer viewer;
    private List<IFile> files;

    public FileSelectWizardPage1(List<IFile> files) {
        super("FileSelectWizardPage1");
        this.setTitle(Messages.getString("FileSelectWizardPage1.0"));
        this.setDescription(Messages.getString("FileSelectWizardPage1.1"));
        this.files = files;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)68352);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText("");
        column = new TableColumn(table, 0);
        column.setText(Messages.getString("FileSelectWizardPage1.2"));
        column = new TableColumn(table, 0);
        column.setText(Messages.getString("FileSelectWizardPage1.3"));
        String[] properties = new String[]{"", "", "text"};
        this.viewer.setColumnProperties(properties);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = new TextCellEditor((Composite)table);
        CellEditor[] editors = cellEditorArray;
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                FileModel model = (FileModel)element;
                if (property == "text") {
                    return model.getTranslatedFileName();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                FileModel model = (FileModel)element;
                if (property == "text" && !"".equals(value)) {
                    File file = new File(String.valueOf(model.getAbsoluteCurrentDir()) + value);
                    model.setTranslatedFileName((String)value);
                    if (file.exists()) {
                        FileSelectWizardPage1.this.setErrorMessage("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                        FileSelectWizardPage1.this.setPageComplete(false);
                    } else {
                        FileSelectWizardPage1.this.setErrorMessage(null);
                        FileSelectWizardPage1.this.setPageComplete(true);
                    }
                }
                FileSelectWizardPage1.this.viewer.update(element, null);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileSelectLabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FileModel model = (FileModel)event.getElement();
                FileSelectWizardPage1.this.setCheckBox(model);
                FileSelectWizardPage1.this.doValidate();
            }
        });
        ArrayList<FileModel> input = new ArrayList<FileModel>();
        List<IFile> list = this.getFiles();
        int i = 0;
        while (i < list.size()) {
            IFile file = list.get(i);
            FileModel model = new FileModel();
            model.setCheckFlg(true);
            model.setRelativeCurrentDir(StringUtils.getRelativeCurrentDir(file));
            model.setAbsoluteCurrentDir(StringUtils.getAbsoluteCurrentDir(file));
            model.setFileName(file.getName());
            model.setTranslatedFileName(StringUtils.getTranslatedFileName(file));
            input.add(model);
            ++i;
        }
        this.viewer.setInput(input);
        this.viewer.setAllChecked(true);
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            columns[i2].pack();
            ++i2;
        }
        this.doValidate();
        this.setControl((Control)composite);
    }

    private void updateStatus() {
        if (this.files.isEmpty()) {
            this.setErrorMessage(Messages.getString("FileSelectWizardPage1.6"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void doValidate() {
        boolean checkFlg = false;
        int i = 0;
        while (i < this.viewer.getCheckedElements().length) {
            FileModel model = (FileModel)this.viewer.getCheckedElements()[i];
            if (model.getCheckFlg()) {
                checkFlg = true;
                break;
            }
            ++i;
        }
        if (!checkFlg) {
            this.setErrorMessage(Messages.getString("FileSelectWizardPage1.6"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private void setCheckBox(FileModel model) {
        if (model.getCheckFlg()) {
            model.setCheckFlg(false);
        } else {
            model.setCheckFlg(true);
        }
    }

    public List<IFile> getFiles() {
        return this.files;
    }

    public List getFileBeans() {
        return (List)this.viewer.getInput();
    }
}

