/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileSearchPage;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileSearchQuery;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.RegExContentAssistProcessor;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.internal.ui.util.ExtendedDialogWindow;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

class ReplaceDialog2
extends ExtendedDialogWindow {
    private static final int REPLACE = 1025;
    private static final int REPLACE_ALL = 1027;
    private static final int REPLACE_ALL_IN_FILE = 1026;
    private static final int SKIP = 1028;
    private static final int SKIP_ALL = 1030;
    private static final int SKIP_FILE = 1029;
    private IReusableEditor fEditor;
    private List fMarkers;
    private FileSearchPage fPage;
    private Button fReplaceAllButton;
    private Button fReplaceAllInFileButton;
    private Button fReplaceButton;
    private ContentAssistHandler fReplaceContentAssistHandler;
    private Button fReplaceWithRegex;
    private boolean fSaved = false;
    private Button fSkipButton;
    private Button fSkipFileButton;
    private boolean fSkipReadonly = false;
    private Label fStatusLabel;
    private Text fTextField;

    protected ReplaceDialog2(Shell parentShell, IFile[] entries, FileSearchPage page) {
        super(parentShell);
        Assert.isNotNull((Object)entries);
        Assert.isNotNull((Object)page.getInput());
        this.fPage = page;
        this.fMarkers = new ArrayList();
        this.initializeMarkers(entries);
    }

    private int askForSkip(IFile file) {
        boolean showSkip;
        String message = SearchMessages.getFormattedString((String)"ReadOnlyDialog.message", (Object)file.getFullPath().toOSString());
        String[] buttonLabels = null;
        boolean bl = showSkip = this.countResources() > 1;
        if (showSkip) {
            String skipLabel = SearchMessages.getString((String)"ReadOnlyDialog.skipFile");
            String skipAllLabel = SearchMessages.getString((String)"ReadOnlyDialog.skipAll");
            buttonLabels = new String[]{skipLabel, skipAllLabel, IDialogConstants.CANCEL_LABEL};
        } else {
            buttonLabels = new String[]{IDialogConstants.CANCEL_LABEL};
        }
        MessageDialog msd = new MessageDialog(this.getShell(), this.getShell().getText(), null, message, 1, buttonLabels, 0);
        int rc = msd.open();
        switch (rc) {
            case 0: {
                return showSkip ? 1029 : 1;
            }
            case 1: {
                return 1030;
            }
        }
        return 1;
    }

    protected void buttonPressed(int buttonId) {
        final String replaceText = this.fTextField.getText();
        this.statusMessage(false, "");
        try {
            switch (buttonId) {
                case 1028: {
                    this.skip();
                    break;
                }
                case 1029: {
                    this.skipFile();
                    break;
                }
                case 1025: {
                    this.run(new ReplaceOperation(){

                        protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                            ReplaceDialog2.this.replace(pm, replaceText);
                        }
                    }, (IResource)this.getCurrentMarker().getElement());
                    this.gotoCurrentMarker();
                    break;
                }
                case 1026: {
                    this.run(new ReplaceOperation(){

                        protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                            ReplaceDialog2.this.replaceInFile(pm, replaceText);
                        }
                    }, (IResource)this.getCurrentMarker().getElement());
                    this.gotoCurrentMarker();
                    break;
                }
                case 1027: {
                    this.run(new ReplaceOperation(){

                        protected void doReplace(IProgressMonitor pm) throws BadLocationException, CoreException {
                            ReplaceDialog2.this.replaceAll(pm, replaceText);
                        }
                    }, (IResource)ResourcesPlugin.getWorkspace().getRoot());
                    this.gotoCurrentMarker();
                    break;
                }
                default: {
                    super.buttonPressed(buttonId);
                    return;
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof PatternSyntaxException) {
                String format = SearchMessages.getString((String)"ReplaceDialog2.regexError.format");
                String message = MessageFormat.format(format, targetException.getLocalizedMessage());
                this.statusMessage(true, message);
            } else {
                String message = SearchMessages.getFormattedString((String)"ReplaceDialog.error.unable_to_replace", (Object)((IFile)this.getCurrentMarker().getElement()).getName());
                ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getParentShell(), (String)this.getDialogTitle(), (String)message);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!(this.hasNextMarker() || this.hasNextFile() || this.canReplace())) {
            this.close();
        } else {
            this.enableButtons();
        }
    }

    private boolean canReplace() {
        return this.fMarkers.size() > 0;
    }

    private Match[] collectMarkers(IFile resource) {
        ArrayList<Match> matching = new ArrayList<Match>();
        int i = 0;
        while (i < this.fMarkers.size()) {
            Match marker = (Match)this.fMarkers.get(i);
            if (!resource.equals(marker.getElement())) break;
            matching.add(marker);
            ++i;
        }
        Match[] markers = new Match[matching.size()];
        return matching.toArray(markers);
    }

    private String computeReplacementString(Pattern pattern, String originalText, String replacementText) {
        if (pattern != null) {
            try {
                return pattern.matcher(originalText).replaceFirst(replacementText);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getLocalizedMessage(), replacementText, -1);
            }
        }
        return replacementText;
    }

    private int countResources() {
        IResource r = null;
        int count = 0;
        Iterator elements = this.fMarkers.iterator();
        while (elements.hasNext()) {
            Match element = (Match)elements.next();
            if (element.getElement().equals(r)) continue;
            ++count;
            r = (IResource)element.getElement();
        }
        return count;
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.setText(this.getDialogTitle());
        this.gotoCurrentMarker();
        this.enableButtons();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fReplaceButton = this.createButton(parent, 1025, SearchMessages.getString((String)"ReplaceDialog.replace"), true);
        this.fReplaceAllInFileButton = this.createButton(parent, 1026, SearchMessages.getString((String)"ReplaceDialog.replaceAllInFile"), false);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(768));
        this.fReplaceAllButton = this.createButton(parent, 1027, SearchMessages.getString((String)"ReplaceDialog.replaceAll"), false);
        this.fSkipButton = this.createButton(parent, 1028, SearchMessages.getString((String)"ReplaceDialog.skip"), false);
        this.fSkipFileButton = this.createButton(parent, 1029, SearchMessages.getString((String)"ReplaceDialog.skipFile"), false);
        filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(768));
        super.createButtonsForButtonBar(parent);
        ((GridLayout)parent.getLayout()).numColumns = 4;
    }

    public static SubjectControlContentAssistant createContentAssistant(ArrayList proposalKeys) {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(SearchPlugin.getDefault().getDialogSettings());
        RegExContentAssistProcessor processor = new RegExContentAssistProcessor(proposalKeys);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    protected Control createPageArea(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.search.replace_dialog_context");
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(SearchMessages.getString((String)"ReplaceDialog.replace_label"));
        Text clabel = new Text(result, 2048);
        clabel.setEnabled(false);
        clabel.setText(((FileSearchQuery)this.fPage.getInput().getQuery()).getSearchString());
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        clabel.setLayoutData((Object)gd);
        label = new Label(result, 0);
        label.setText(SearchMessages.getString((String)"ReplaceDialog.with_label"));
        this.fTextField = new Text(result, 2048);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTextField.setLayoutData((Object)gd);
        this.fTextField.setFocus();
        new Label(result, 0);
        this.fReplaceWithRegex = new Button(result, 32);
        this.fReplaceWithRegex.setText(SearchMessages.getString((String)"ReplaceDialog.isRegex.label"));
        this.fReplaceWithRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplaceDialog2.this.setContentAssistsEnablement(ReplaceDialog2.this.fReplaceWithRegex.getSelection());
            }
        });
        if (this.isRegexQuery()) {
            this.fReplaceWithRegex.setSelection(true);
        } else {
            this.fReplaceWithRegex.setSelection(false);
            this.fReplaceWithRegex.setEnabled(false);
        }
        this.fStatusLabel = new Label(result, 0);
        gd = new GridData(768);
        gd.verticalAlignment = 1024;
        gd.horizontalSpan = 2;
        this.fStatusLabel.setLayoutData((Object)gd);
        this.setContentAssistsEnablement(this.fReplaceWithRegex.getSelection());
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Pattern createReplacePattern() {
        FileSearchQuery query = (FileSearchQuery)this.fPage.getInput().getQuery();
        if (!query.isCaseSensitive()) {
            return Pattern.compile(query.getSearchString(), 66);
        }
        return Pattern.compile(query.getSearchString());
    }

    private boolean disableAutobuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean autobuild = workspace.isAutoBuilding();
        if (autobuild) {
            IWorkspaceDescription description = workspace.getDescription();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
        }
        return autobuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doReplaceInFile(IProgressMonitor pm, IFile file, String replacementText, Match[] markers) throws BadLocationException, CoreException {
        block20: {
            block18: {
                block17: {
                    block16: {
                        Pattern pattern = null;
                        if (this.fReplaceWithRegex.getSelection()) {
                            pattern = this.createReplacePattern();
                        }
                        try {
                            if (file.isReadOnly()) {
                                if (this.fSkipReadonly) {
                                    this.skipFile();
                                    Object var20_6 = null;
                                    break block16;
                                }
                                int rc = this.askForSkip(file);
                                switch (rc) {
                                    case 1: {
                                        throw new OperationCanceledException();
                                    }
                                    case 1029: {
                                        this.skipFile();
                                        break block17;
                                    }
                                    case 1030: {
                                        this.fSkipReadonly = true;
                                        this.skipFile();
                                        break block18;
                                    }
                                }
                            }
                            ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
                            try {
                                bm.connect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                ITextFileBuffer fb = bm.getTextFileBuffer(file.getFullPath());
                                boolean wasDirty = fb.isDirty();
                                IDocument doc = fb.getDocument();
                                int i = 0;
                                while (true) {
                                    if (i >= markers.length) {
                                        if (!wasDirty) {
                                            fb.commit((IProgressMonitor)new SubProgressMonitor(pm, 1), true);
                                            this.fSaved = true;
                                        }
                                        Object var18_23 = null;
                                        break;
                                    }
                                    PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
                                    int offset = markers[i].getOffset();
                                    int length = markers[i].getLength();
                                    Position currentPosition = tracker.getCurrentPosition(markers[i]);
                                    if (currentPosition != null) {
                                        offset = currentPosition.offset;
                                        length = currentPosition.length;
                                    }
                                    String originalText = doc.get(offset, length);
                                    String replacementString = this.computeReplacementString(pattern, originalText, replacementText);
                                    doc.replace(offset, length, replacementString);
                                    this.fMarkers.remove(0);
                                    this.fPage.getInput().removeMatch(markers[i]);
                                    ++i;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var18_24 = null;
                                bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                throw throwable;
                            }
                            bm.disconnect(file.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            break block20;
                        }
                        catch (Throwable throwable) {
                            Object var20_10 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return;
                }
                Object var20_7 = null;
                pm.done();
                return;
            }
            Object var20_8 = null;
            pm.done();
            return;
        }
        Object var20_9 = null;
        pm.done();
    }

    private void enableButtons() {
        this.fSkipButton.setEnabled(this.hasNextMarker());
        this.fSkipFileButton.setEnabled(this.hasNextFile());
        this.fReplaceButton.setEnabled(this.canReplace());
        this.fReplaceAllInFileButton.setEnabled(this.canReplace());
        this.fReplaceAllButton.setEnabled(this.canReplace());
    }

    private Match getCurrentMarker() {
        return (Match)this.fMarkers.get(0);
    }

    private String getDialogTitle() {
        return SearchMessages.getString((String)"ReplaceDialog.dialog.title");
    }

    private void gotoCurrentMarker() {
        if (this.fMarkers.size() > 0) {
            Match marker = this.getCurrentMarker();
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            try {
                this.selectEntry(marker);
                ITextEditor editor = null;
                editor = NewSearchUI.reuseEditor() ? this.openEditorReuse(marker) : this.openEditorNoReuse(marker);
                Position p = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(marker);
                if (p != null) {
                    editor.selectAndReveal(p.getOffset(), p.getLength());
                } else {
                    editor.selectAndReveal(marker.getOffset(), marker.getLength());
                }
                if (focusControl != null && !focusControl.isDisposed()) {
                    focusControl.setFocus();
                }
            }
            catch (PartInitException e) {
                String message = SearchMessages.getFormattedString((String)"ReplaceDialog.error.unable_to_open_text_editor", (Object)((IFile)marker.getElement()).getName());
                MessageDialog.openError((Shell)this.getParentShell(), (String)this.getDialogTitle(), (String)message);
            }
        }
    }

    private boolean hasNextFile() {
        if (!this.hasNextMarker()) {
            return false;
        }
        IResource currentFile = (IResource)this.getCurrentMarker().getElement();
        int i = 0;
        while (i < this.fMarkers.size()) {
            if (!((Match)this.fMarkers.get(i)).getElement().equals(currentFile)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasNextMarker() {
        return this.fMarkers.size() > 1;
    }

    private void initializeMarkers(IFile[] entries) {
        int j = 0;
        while (j < entries.length) {
            IFile entry = entries[j];
            Match[] matches = this.fPage.getDisplayedMatches(entry);
            int i = 0;
            while (i < matches.length) {
                this.fMarkers.add(matches[i]);
                ++i;
            }
            ++j;
        }
    }

    private boolean isEditorOpen(IWorkbenchPage page, IEditorPart editor) {
        if (editor != null) {
            IEditorReference[] parts = page.getEditorReferences();
            int i = 0;
            int j = 0;
            while (j < parts.length) {
                if (editor == parts[i++].getEditor(false)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private boolean isRegexQuery() {
        return ((FileSearchQuery)this.fPage.getInput().getQuery()).isRegexSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open() {
        boolean wasAutobuild = false;
        try {
            wasAutobuild = this.disableAutobuild();
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)SearchMessages.getString((String)"ReplaceDialog2.error.disableAutobuild"));
        }
        try {
            int n = super.open();
            return n;
        }
        finally {
            if (wasAutobuild) {
                try {
                    this.restoreAutobuild();
                }
                catch (CoreException e1) {
                    ExceptionHandler.handle((CoreException)e1, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)SearchMessages.getString((String)"ReplaceDialog2.error.restoreAutobuild"));
                    return 1;
                }
            }
        }
    }

    private ITextEditor openEditorNoReuse(Match marker) throws PartInitException {
        IFile file = (IFile)marker.getElement();
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        ITextEditor textEditor = this.showOpenTextEditor(activePage, file);
        if (textEditor != null) {
            return textEditor;
        }
        return this.openNewTextEditor(file, activePage);
    }

    private ITextEditor openEditorReuse(Match marker) throws PartInitException {
        boolean showsSameInputType;
        boolean isOpen;
        IWorkbenchPage page = SearchPlugin.getActivePage();
        IFile file = (IFile)marker.getElement();
        if (page == null) {
            return null;
        }
        ITextEditor textEditor = this.showOpenTextEditor(page, file);
        if (textEditor != null) {
            return textEditor;
        }
        String editorId = null;
        IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
        if (desc != null && desc.isInternal()) {
            editorId = desc.getId();
        }
        boolean canBeReused = (isOpen = this.isEditorOpen(page, (IEditorPart)this.fEditor)) && !this.fEditor.isDirty() && !this.isPinned((IEditorPart)this.fEditor);
        boolean bl = showsSameInputType = this.fEditor != null && (editorId == null || this.fEditor.getSite().getId().equals(editorId));
        if (canBeReused) {
            if (showsSameInputType) {
                this.fEditor.setInput((IEditorInput)new FileEditorInput(file));
                page.bringToTop((IWorkbenchPart)this.fEditor);
                return (ITextEditor)this.fEditor;
            }
            page.closeEditor((IEditorPart)this.fEditor, false);
            this.fEditor = null;
        }
        return this.openNewTextEditor(file, page);
    }

    private ITextEditor openNewTextEditor(IFile file, IWorkbenchPage activePage) throws PartInitException {
        IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
        if (desc != null) {
            String editorID = desc.getId();
            if (desc.isInternal()) {
                IEditorPart editor = activePage.openEditor((IEditorInput)new FileEditorInput(file), editorID);
                if (editor instanceof ITextEditor) {
                    if (editor instanceof IReusableEditor) {
                        this.fEditor = (IReusableEditor)editor;
                    }
                    return (ITextEditor)editor;
                }
                activePage.closeEditor(editor, false);
            }
        }
        IEditorPart editor = activePage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.DefaultTextEditor");
        return (ITextEditor)editor;
    }

    private void replace(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        Match marker = this.getCurrentMarker();
        pm.beginTask(SearchMessages.getString((String)"ReplaceDialog.task.replace"), 10);
        this.replaceInFile(pm, (IFile)marker.getElement(), replacementText, new Match[]{marker});
    }

    private void replaceAll(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        int resourceCount = this.countResources();
        pm.beginTask(SearchMessages.getString((String)"ReplaceDialog.task.replace.replaceAll"), resourceCount);
        while (this.fMarkers.size() > 0) {
            this.replaceInFile((IProgressMonitor)new SubProgressMonitor(pm, 1, 0), replacementText);
        }
        pm.done();
    }

    private void replaceInFile(IProgressMonitor pm, IFile file, String replacementText, Match[] markers) throws BadLocationException, CoreException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.doReplaceInFile(pm, file, replacementText, markers);
    }

    private void replaceInFile(IProgressMonitor pm, String replacementText) throws BadLocationException, CoreException {
        Match firstMarker = this.getCurrentMarker();
        Match[] markers = this.collectMarkers((IFile)firstMarker.getElement());
        pm.beginTask(SearchMessages.getFormattedString((String)"ReplaceDialog.task.replaceInFile", (Object)((IFile)firstMarker.getElement()).getFullPath().toOSString()), 4);
        this.replaceInFile(pm, (IFile)firstMarker.getElement(), replacementText, markers);
    }

    private void restoreAutobuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(true);
        workspace.setDescription(description);
        if (this.fSaved) {
            new GlobalBuildAction(this.fPage.getSite().getWorkbenchWindow(), 10).run();
        }
    }

    private void run(ReplaceOperation operation, IResource resource) throws InvocationTargetException, InterruptedException {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = ruleFactory.modifyRule(resource);
        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this, (IRunnableWithProgress)operation, rule);
    }

    private void selectEntry(Match marker) {
        ISelection sel = this.fPage.getViewer().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        IFile file = (IFile)marker.getElement();
        if (ss.size() == 1 && file.equals(ss.getFirstElement())) {
            return;
        }
        this.fPage.getViewer().setSelection((ISelection)new StructuredSelection(marker.getElement()));
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fReplaceContentAssistHandler == null) {
                this.fReplaceContentAssistHandler = ContentAssistHandler.createHandlerForText((Text)this.fTextField, (SubjectControlContentAssistant)ReplaceDialog2.createContentAssistant(RegExContentAssistProcessor.fgReplaceProposalKeys));
            }
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fReplaceContentAssistHandler == null) {
                return;
            }
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    private ITextEditor showOpenTextEditor(IWorkbenchPage page, IFile file) {
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        if (editor instanceof ITextEditor) {
            page.bringToTop((IWorkbenchPart)editor);
            return (ITextEditor)editor;
        }
        return null;
    }

    private void skip() {
        this.fMarkers.remove(0);
        Assert.isTrue((this.fMarkers.size() > 0 ? 1 : 0) != 0);
        this.gotoCurrentMarker();
    }

    private void skipFile() {
        Match currentMarker = this.getCurrentMarker();
        if (currentMarker == null) {
            return;
        }
        IResource currentFile = (IResource)currentMarker.getElement();
        while (this.fMarkers.size() > 0 && this.getCurrentMarker().getElement().equals(currentFile)) {
            this.fMarkers.remove(0);
        }
        this.gotoCurrentMarker();
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    private static abstract class ReplaceOperation
    implements IRunnableWithProgress {
        private ReplaceOperation() {
        }

        protected abstract void doReplace(IProgressMonitor var1) throws BadLocationException, CoreException, IOException;

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                this.doReplace(monitor);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

