/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.bean;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class AppSetting
implements Serializable {
    private Color backgroundColor;
    public static final String filepath = "ini";
    private Font font;
    private Color foregroundColor;
    private Dimension framesize;
    private String lookAndFeelClass;
    private Vector openFileHistory = new Vector();
    private static AppSetting setting;
    private boolean showLineNumberFlag;
    private boolean showToolBarFlag;
    private boolean wordWrapFlag;

    private AppSetting() {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Dimension getFramesize() {
        return this.framesize;
    }

    public static AppSetting getInstance() {
        if (setting == null) {
            setting = new AppSetting();
        }
        return setting;
    }

    public String getLookAndFeelClass() {
        return this.lookAndFeelClass;
    }

    public Vector getOpenFileHistory() {
        return this.openFileHistory;
    }

    public boolean isShowLineNumberFlag() {
        return this.showLineNumberFlag;
    }

    public boolean isShowToolBarFlag() {
        return this.showToolBarFlag;
    }

    public boolean isWordWrapFlag() {
        return this.wordWrapFlag;
    }

    public void loadSetting() throws FileNotFoundException, ClassNotFoundException, IOException {
        File file = new File(filepath);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        AppSetting appSetting = (AppSetting)objectInputStream.readObject();
        objectInputStream.close();
        this.setOpenFileHistory(appSetting.getOpenFileHistory());
        this.setShowLineNumberFlag(appSetting.isShowLineNumberFlag());
        this.setShowToolBarFlag(appSetting.isShowToolBarFlag());
        this.setWordWrapFlag(appSetting.isWordWrapFlag());
        this.setFramesize(appSetting.getFramesize());
        this.setFont(appSetting.getFont());
        this.setForegroundColor(appSetting.getForegroundColor());
        this.setBackgroundColor(appSetting.getBackgroundColor());
        this.setLookAndFeelClass(appSetting.getLookAndFeelClass());
        Vector vector = this.getOpenFileHistory();
        if (vector.size() >= 10) {
            int n = vector.size() - 10;
            int n2 = 0;
            while (n2 < n) {
                vector.remove(0);
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    public void saveSetting() throws FileNotFoundException, IOException {
        File file = new File(filepath);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public void setFramesize(Dimension dimension) {
        this.framesize = dimension;
    }

    public void setLookAndFeelClass(String string) {
        this.lookAndFeelClass = string;
    }

    public void setOpenFileHistory(File file) {
        this.openFileHistory.add(file);
    }

    private void setOpenFileHistory(Vector vector) {
        this.openFileHistory = vector;
        if (vector.size() == 11) {
            vector.remove(10);
        }
    }

    public void setShowLineNumberFlag(boolean bl) {
        this.showLineNumberFlag = bl;
    }

    public void setShowToolBarFlag(boolean bl) {
        this.showToolBarFlag = bl;
    }

    public void setWordWrapFlag(boolean bl) {
        this.wordWrapFlag = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

