/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors;

import jp.sf.propdev.editors.ColorManager;
import jp.sf.propdev.editors.IPROPERTIESColorConstants;
import jp.sf.propdev.editors.NonRuleBasedDamagerRepairer;
import jp.sf.propdev.editors.PropertiesCommentFormattingStrategy;
import jp.sf.propdev.editors.PropertiesScanner;
import jp.sf.propdev.editors.PropertiesSectionScanner;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class PropertiesConfiguration
extends SourceViewerConfiguration {
    private DefaultTextDoubleClickStrategy doubleClickStrategy;
    private PropertiesSectionScanner sectionScanner;
    private PropertiesScanner scanner;
    private ColorManager colorManager;

    public PropertiesConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__properties_comment", "__properties_section"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DefaultTextDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected PropertiesSectionScanner getPropertiesSectionScanner() {
        if (this.sectionScanner == null) {
            this.sectionScanner = new PropertiesSectionScanner(this.colorManager);
            this.sectionScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IPROPERTIESColorConstants.SECTION))));
        }
        return this.sectionScanner;
    }

    protected PropertiesScanner getPropertiesScanner() {
        if (this.scanner == null) {
            this.scanner = new PropertiesScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IPROPERTIESColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer sdr = new DefaultDamagerRepairer((ITokenScanner)this.getPropertiesSectionScanner());
        reconciler.setDamager((IPresentationDamager)sdr, "__properties_section");
        reconciler.setRepairer((IPresentationRepairer)sdr, "__properties_section");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new RuleBasedScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IPROPERTIESColorConstants.PROPERTIES_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__properties_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__properties_comment");
        return reconciler;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setFormattingStrategy((IFormattingStrategy)new PropertiesCommentFormattingStrategy(), "__properties_comment");
        return formatter;
    }
}

