/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V>
implements Map<K, V> {
    private final Map<K, LinkedList<V>> map;
    private int nSize = 0;
    private int maxSize = Integer.MAX_VALUE;
    private final LinkedList<V> emptyList = new LinkedList();

    public MultiMap(Map<K, LinkedList<V>> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.nSize = 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#containsValue");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#entrySet");
    }

    @Override
    public V get(Object object) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#get(), use getList");
    }

    public LinkedList<V> getList(K k) {
        return this.map.get(k);
    }

    public LinkedList<V> getWithoutNull(K k) {
        LinkedList<V> linkedList = this.getList(k);
        if (linkedList != null) {
            return linkedList;
        }
        return this.emptyList;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K k, V v) {
        this.put(k, v, false);
        return v;
    }

    public void putUniq(K k, V v) {
        this.put(k, v, true);
    }

    private void put(K k, V v, boolean bl) {
        LinkedList<Object> linkedList = this.getList(k);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.map.put(k, linkedList);
        } else if (bl) {
            for (Object e : linkedList) {
                if (!e.equals(v)) continue;
                return;
            }
        }
        if (linkedList.size() < this.maxSize) {
            linkedList.add(v);
            ++this.nSize;
        }
    }

    public void setMaxEntrySize(int n) {
        this.maxSize = n;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#putAll");
    }

    @Override
    public V remove(Object object) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#remove()");
    }

    @Override
    public int size() {
        return this.nSize;
    }

    @Override
    public Collection<V> values() {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#values()");
    }
}

