/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class WriteDecodedDoc {
    private static final String PASSWORD = "-password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in, String out, String password) throws IOException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load(new File(in), password);
            doc.setAllSecurityToBeRemoved(true);
            Iterator<COSObject> i = doc.getDocument().getObjects().iterator();
            while (i.hasNext()) {
                COSBase base = i.next().getObject();
                if (!(base instanceof COSStream)) continue;
                COSStream stream = (COSStream)base;
                byte[] bytes = new PDStream(stream).toByteArray();
                stream.removeItem(COSName.FILTER);
                OutputStream streamOut = stream.createOutputStream();
                streamOut.write(bytes);
                streamOut.close();
            }
            doc.getDocumentCatalog();
            doc.save(out);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        WriteDecodedDoc app = new WriteDecodedDoc();
        String password = "";
        String pdfFile = null;
        String outputFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    WriteDecodedDoc.usage();
                }
                password = args[i];
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i];
                continue;
            }
            outputFile = args[i];
        }
        if (pdfFile == null) {
            WriteDecodedDoc.usage();
        } else {
            if (outputFile == null) {
                outputFile = WriteDecodedDoc.calculateOutputFilename(pdfFile);
            }
            app.doIt(pdfFile, outputFile, password);
        }
    }

    private static String calculateOutputFilename(String filename) {
        String outputFilename = filename.toLowerCase().endsWith(".pdf") ? filename.substring(0, filename.length() - 4) : filename;
        outputFilename = outputFilename + "_unc.pdf";
        return outputFilename;
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar WriteDecodedDoc [options] <inputfile> [outputfile]\n\nOptions:\n  -password <password> : Password to decrypt the document\n  <inputfile>          : The PDF document to be decompressed\n  [outputfile]         : The filename for the decompressed pdf\n";
        System.err.println(message);
        System.exit(1);
    }
}

