/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.debugger.colorpane.CSArrayBased;
import org.apache.pdfbox.debugger.colorpane.CSDeviceN;
import org.apache.pdfbox.debugger.colorpane.CSIndexed;
import org.apache.pdfbox.debugger.colorpane.CSSeparation;
import org.apache.pdfbox.debugger.flagbitspane.FlagBitsPane;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingPaneController;
import org.apache.pdfbox.debugger.pagepane.PagePane;
import org.apache.pdfbox.debugger.streampane.StreamPane;
import org.apache.pdfbox.debugger.stringpane.StringPane;
import org.apache.pdfbox.debugger.treestatus.TreeStatus;
import org.apache.pdfbox.debugger.treestatus.TreeStatusPane;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.DocumentEntry;
import org.apache.pdfbox.debugger.ui.ErrorDialog;
import org.apache.pdfbox.debugger.ui.ExtensionFileFilter;
import org.apache.pdfbox.debugger.ui.FileOpenSaveDialog;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.debugger.ui.OSXAdapter;
import org.apache.pdfbox.debugger.ui.PDFTreeCellRenderer;
import org.apache.pdfbox.debugger.ui.PDFTreeModel;
import org.apache.pdfbox.debugger.ui.PageEntry;
import org.apache.pdfbox.debugger.ui.RecentFiles;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.Tree;
import org.apache.pdfbox.debugger.ui.ZoomMenu;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.printing.PDFPageable;

public class PDFDebugger
extends JFrame {
    private static final Set<COSName> SPECIALCOLORSPACES = new HashSet<COSName>(Arrays.asList(COSName.INDEXED, COSName.SEPARATION, COSName.DEVICEN));
    private static final Set<COSName> OTHERCOLORSPACES = new HashSet<COSName>(Arrays.asList(COSName.ICCBASED, COSName.PATTERN, COSName.CALGRAY, COSName.CALRGB, COSName.LAB));
    private static final String PASSWORD = "-password";
    private static final String VIEW_STRUCTURE = "-viewstructure";
    private static final int SHORCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private TreeStatusPane statusPane;
    private RecentFiles recentFiles;
    private boolean isPageMode;
    private PDDocument document;
    private String currentFilePath;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_MAC_OS = OS_NAME.startsWith("mac os x");
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private Tree tree;
    private final JPanel documentPanel = new JPanel();
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenu recentFilesMenu;
    private JMenuItem printMenuItem;
    private JMenu findMenu;
    private JMenuItem findMenuItem;
    private JMenuItem findNextMenuItem;
    private JMenuItem findPreviousMenuItem;
    private JMenuItem viewModeItem;

    public PDFDebugger() {
        this(false);
    }

    public PDFDebugger(boolean viewPages) {
        this.isPageMode = viewPages;
        this.initComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new Tree(this);
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.tree.setCellRenderer(new PDFTreeCellRenderer());
        this.tree.setModel(null);
        this.setTitle("PDFBox Debugger");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PDFDebugger.this.tree.requestFocusInWindow();
                super.windowOpened(windowEvent);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                PDFDebugger.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBorder(new BevelBorder(0));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 500));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PDFDebugger.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jSplitPane1.setDividerSize(3);
        this.jScrollPane2.setPreferredSize(new Dimension(300, 500));
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.statusPane = new TreeStatusPane(this.tree);
        this.statusPane.getPanel().setBorder(new BevelBorder(0));
        this.statusPane.getPanel().setPreferredSize(new Dimension(300, 25));
        this.getContentPane().add((Component)this.statusPane.getPanel(), "First");
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createViewMenu());
        this.setJMenuBar(menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                try {
                    Transferable transferable = transferSupport.getTransferable();
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    PDFDebugger.this.readPDFFile((File)files.get(0), "");
                    return true;
                }
                catch (IOException e) {
                    new ErrorDialog(e).setVisible(true);
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (IS_MAC_OS) {
            try {
                Method osxOpenFiles = this.getClass().getDeclaredMethod("osxOpenFiles", String.class);
                osxOpenFiles.setAccessible(true);
                OSXAdapter.setFileHandler(this, osxOpenFiles);
                Method osxQuit = this.getClass().getDeclaredMethod("osxQuit", new Class[0]);
                osxQuit.setAccessible(true);
                OSXAdapter.setQuitHandler(this, osxQuit);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private JMenu createFileMenu() {
        JMenuItem openMenuItem = new JMenuItem("Open...");
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, SHORCUT_KEY_MASK));
        openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFDebugger.this.openMenuItemActionPerformed(evt);
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(openMenuItem);
        JMenuItem openUrlMenuItem = new JMenuItem("Open URL...");
        openUrlMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, SHORCUT_KEY_MASK));
        openUrlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String urlString = JOptionPane.showInputDialog("Enter an URL");
                if (urlString == null || urlString.isEmpty()) {
                    return;
                }
                try {
                    PDFDebugger.this.readPDFurl(urlString, "");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        fileMenu.add(openUrlMenuItem);
        try {
            this.recentFiles = new RecentFiles(this.getClass(), 5);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.recentFilesMenu = new JMenu("Open Recent");
        this.recentFilesMenu.setEnabled(false);
        this.addRecentFileItems();
        fileMenu.add(this.recentFilesMenu);
        this.printMenuItem = new JMenuItem("Print");
        this.printMenuItem.setEnabled(false);
        this.printMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFDebugger.this.printMenuItemActionPerformed(evt);
            }
        });
        if (!IS_MAC_OS) {
            fileMenu.addSeparator();
            fileMenu.add(this.printMenuItem);
        }
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFDebugger.this.exitMenuItemActionPerformed(evt);
            }
        });
        if (!IS_MAC_OS) {
            fileMenu.addSeparator();
            fileMenu.add(exitMenuItem);
        }
        return fileMenu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        JMenuItem cutMenuItem = new JMenuItem("Cut");
        cutMenuItem.setEnabled(false);
        editMenu.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy");
        copyMenuItem.setEnabled(false);
        editMenu.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste");
        pasteMenuItem.setEnabled(false);
        editMenu.add(pasteMenuItem);
        JMenuItem deleteMenuItem = new JMenuItem("Delete");
        deleteMenuItem.setEnabled(false);
        editMenu.add(deleteMenuItem);
        editMenu.addSeparator();
        editMenu.add(this.createFindMenu());
        return editMenu;
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu("View");
        this.viewModeItem = this.isPageMode ? new JMenuItem("Show Internal Structure") : new JMenuItem("Show Pages");
        this.viewModeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PDFDebugger.this.isPageMode) {
                    PDFDebugger.this.viewModeItem.setText("Show Pages");
                    PDFDebugger.this.isPageMode = false;
                } else {
                    PDFDebugger.this.viewModeItem.setText("Show Internal Structure");
                    PDFDebugger.this.isPageMode = true;
                }
                if (PDFDebugger.this.document != null) {
                    PDFDebugger.this.initTree();
                }
            }
        });
        viewMenu.add(this.viewModeItem);
        ZoomMenu zoomMenu = ZoomMenu.getInstance();
        zoomMenu.setEnableMenu(false);
        viewMenu.add(zoomMenu.getMenu());
        RotationMenu rotationMenu = RotationMenu.getInstance();
        rotationMenu.setEnableMenu(false);
        viewMenu.add(rotationMenu.getMenu());
        return viewMenu;
    }

    private JMenu createFindMenu() {
        this.findMenu = new JMenu("Find");
        this.findMenu.setEnabled(false);
        this.findMenuItem = new JMenuItem("Find...");
        this.findMenuItem.setActionCommand("find");
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, SHORCUT_KEY_MASK));
        this.findNextMenuItem = new JMenuItem("Find Next");
        if (IS_MAC_OS) {
            this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, SHORCUT_KEY_MASK));
        } else {
            this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        }
        this.findPreviousMenuItem = new JMenuItem("Find Previous");
        if (IS_MAC_OS) {
            this.findPreviousMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, SHORCUT_KEY_MASK | 0x40));
        } else {
            this.findPreviousMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 64));
        }
        this.findMenu.add(this.findMenuItem);
        this.findMenu.add(this.findNextMenuItem);
        this.findMenu.add(this.findPreviousMenuItem);
        return this.findMenu;
    }

    public JMenu getFindMenu() {
        return this.findMenu;
    }

    public JMenuItem getFindMenuItem() {
        return this.findMenuItem;
    }

    public JMenuItem getFindNextMenuItem() {
        return this.findNextMenuItem;
    }

    public JMenuItem getFindPreviousMenuItem() {
        return this.findPreviousMenuItem;
    }

    private void osxOpenFiles(String filename) {
        try {
            this.readPDFFile(filename, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void osxQuit() {
        this.exitMenuItemActionPerformed(null);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (IS_MAC_OS) {
                FileDialog openDialog = new FileDialog((Frame)this, "Open");
                openDialog.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String s) {
                        return file.getName().toLowerCase().endsWith(".pdf");
                    }
                });
                openDialog.setVisible(true);
                if (openDialog.getFile() != null) {
                    this.readPDFFile(openDialog.getFile(), "");
                }
            } else {
                String[] extensions = new String[]{"pdf", "PDF"};
                ExtensionFileFilter pdfFilter = new ExtensionFileFilter(extensions, "PDF Files (*.pdf)");
                FileOpenSaveDialog openDialog = new FileOpenSaveDialog(this, pdfFilter);
                File file = openDialog.openFile();
                if (file != null) {
                    this.readPDFFile(file, "");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            try {
                Object selectedNode = path.getLastPathComponent();
                if (this.isPage(selectedNode)) {
                    this.showPage(selectedNode);
                    return;
                }
                if (this.isSpecialColorSpace(selectedNode) || this.isOtherColorSpace(selectedNode)) {
                    this.showColorPane(selectedNode);
                    return;
                }
                if (path.getParentPath() != null && this.isFlagNode(selectedNode, path.getParentPath().getLastPathComponent())) {
                    Object parentNode = path.getParentPath().getLastPathComponent();
                    this.showFlagPane(parentNode, selectedNode);
                    return;
                }
                if (this.isStream(selectedNode)) {
                    this.showStream((COSStream)this.getUnderneathObject(selectedNode), path);
                    return;
                }
                if (this.isFont(selectedNode)) {
                    this.showFont(selectedNode, path);
                    return;
                }
                if (this.isString(selectedNode)) {
                    this.showString(selectedNode);
                    return;
                }
                if (this.jSplitPane1.getRightComponent() == null || !this.jSplitPane1.getRightComponent().equals(this.jScrollPane2)) {
                    this.replaceRightComponent(this.jScrollPane2);
                }
                this.jTextPane1.setText(this.convertToString(selectedNode));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isSpecialColorSpace(Object selectedNode) {
        COSBase arrayEntry;
        if ((selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSArray && ((COSArray)selectedNode).size() > 0 && (arrayEntry = ((COSArray)selectedNode).get(0)) instanceof COSName) {
            COSName name = (COSName)arrayEntry;
            return SPECIALCOLORSPACES.contains(name);
        }
        return false;
    }

    private boolean isOtherColorSpace(Object selectedNode) {
        COSBase arrayEntry;
        if ((selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSArray && ((COSArray)selectedNode).size() > 0 && (arrayEntry = ((COSArray)selectedNode).get(0)) instanceof COSName) {
            COSName name = (COSName)arrayEntry;
            return OTHERCOLORSPACES.contains(name);
        }
        return false;
    }

    private boolean isPage(Object selectedNode) {
        COSDictionary dict;
        COSBase typeItem;
        return (selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSDictionary ? COSName.PAGE.equals(typeItem = (dict = (COSDictionary)selectedNode).getItem(COSName.TYPE)) : selectedNode instanceof PageEntry;
    }

    private boolean isFlagNode(Object selectedNode, Object parentNode) {
        if (selectedNode instanceof MapEntry) {
            COSName key = ((MapEntry)selectedNode).getKey();
            return COSName.FLAGS.equals(key) && this.isFontDescriptor(parentNode) || COSName.F.equals(key) && this.isAnnot(parentNode) || COSName.FF.equals(key) || COSName.PANOSE.equals(key) || COSName.P.equals(key) && this.isEncrypt(parentNode);
        }
        return false;
    }

    private boolean isEncrypt(Object obj) {
        if (obj instanceof MapEntry) {
            MapEntry entry = (MapEntry)obj;
            return COSName.ENCRYPT.equals(entry.getKey()) && entry.getValue() instanceof COSDictionary;
        }
        return false;
    }

    private boolean isFontDescriptor(Object obj) {
        Object underneathObject = this.getUnderneathObject(obj);
        return underneathObject instanceof COSDictionary && ((COSDictionary)underneathObject).containsKey(COSName.TYPE) && ((COSDictionary)underneathObject).getCOSName(COSName.TYPE).equals(COSName.FONT_DESC);
    }

    private boolean isAnnot(Object obj) {
        Object underneathObject = this.getUnderneathObject(obj);
        return underneathObject instanceof COSDictionary && ((COSDictionary)underneathObject).containsKey(COSName.TYPE) && ((COSDictionary)underneathObject).getCOSName(COSName.TYPE).equals(COSName.ANNOT);
    }

    private boolean isStream(Object selectedNode) {
        return this.getUnderneathObject(selectedNode) instanceof COSStream;
    }

    private boolean isString(Object selectedNode) {
        return this.getUnderneathObject(selectedNode) instanceof COSString;
    }

    private boolean isFont(Object selectedNode) {
        if ((selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)selectedNode;
            return dic.containsKey(COSName.TYPE) && dic.getCOSName(COSName.TYPE).equals(COSName.FONT) && !this.isCIDFont(dic);
        }
        return false;
    }

    private boolean isCIDFont(COSDictionary dic) {
        return dic.containsKey(COSName.SUBTYPE) && (dic.getCOSName(COSName.SUBTYPE).equals(COSName.CID_FONT_TYPE0) || dic.getCOSName(COSName.SUBTYPE).equals(COSName.CID_FONT_TYPE2));
    }

    private void showColorPane(Object csNode) {
        COSArray array;
        COSBase arrayEntry;
        if ((csNode = this.getUnderneathObject(csNode)) instanceof COSArray && ((COSArray)csNode).size() > 0 && (arrayEntry = (array = (COSArray)csNode).get(0)) instanceof COSName) {
            COSName csName = (COSName)arrayEntry;
            if (csName.equals(COSName.SEPARATION)) {
                this.replaceRightComponent(new CSSeparation(array).getPanel());
            } else if (csName.equals(COSName.DEVICEN)) {
                this.replaceRightComponent(new CSDeviceN(array).getPanel());
            } else if (csName.equals(COSName.INDEXED)) {
                this.replaceRightComponent(new CSIndexed(array).getPanel());
            } else if (OTHERCOLORSPACES.contains(csName)) {
                this.replaceRightComponent(new CSArrayBased(array).getPanel());
            }
        }
    }

    private void showPage(Object selectedNode) {
        COSDictionary page = (selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSDictionary ? (COSDictionary)selectedNode : ((PageEntry)selectedNode).getDict();
        COSBase typeItem = page.getItem(COSName.TYPE);
        if (COSName.PAGE.equals(typeItem)) {
            PagePane pagePane = new PagePane(this.document, page);
            this.replaceRightComponent(new JScrollPane(pagePane.getPanel()));
        }
    }

    private void showFlagPane(Object parentNode, Object selectedNode) {
        if ((parentNode = this.getUnderneathObject(parentNode)) instanceof COSDictionary) {
            selectedNode = ((MapEntry)selectedNode).getKey();
            selectedNode = this.getUnderneathObject(selectedNode);
            FlagBitsPane flagBitsPane = new FlagBitsPane((COSDictionary)parentNode, (COSName)selectedNode);
            this.replaceRightComponent(flagBitsPane.getPane());
        }
    }

    private void showStream(COSStream stream, TreePath path) throws IOException {
        Object pageObj;
        boolean isContentStream = false;
        boolean isThumb = false;
        COSName key = this.getNodeKey(path.getLastPathComponent());
        COSName parentKey = this.getNodeKey(path.getParentPath().getLastPathComponent());
        COSDictionary resourcesDic = null;
        if (COSName.CONTENTS.equals(key)) {
            pageObj = path.getParentPath().getLastPathComponent();
            COSDictionary page = (COSDictionary)this.getUnderneathObject(pageObj);
            resourcesDic = (COSDictionary)page.getDictionaryObject(COSName.RESOURCES);
            isContentStream = true;
        } else if (COSName.CONTENTS.equals(parentKey) || COSName.CHAR_PROCS.equals(parentKey)) {
            pageObj = path.getParentPath().getParentPath().getLastPathComponent();
            COSDictionary page = (COSDictionary)this.getUnderneathObject(pageObj);
            resourcesDic = (COSDictionary)page.getDictionaryObject(COSName.RESOURCES);
            isContentStream = true;
        } else if (COSName.FORM.equals(stream.getCOSName(COSName.SUBTYPE)) || COSName.PATTERN.equals(stream.getCOSName(COSName.TYPE))) {
            if (stream.containsKey(COSName.RESOURCES)) {
                resourcesDic = (COSDictionary)stream.getDictionaryObject(COSName.RESOURCES);
            }
            isContentStream = true;
        } else if (COSName.THUMB.equals(key)) {
            resourcesDic = null;
            isThumb = true;
        } else if (COSName.IMAGE.equals(stream.getCOSName(COSName.SUBTYPE))) {
            Object resourcesObj = path.getParentPath().getParentPath().getLastPathComponent();
            resourcesDic = (COSDictionary)this.getUnderneathObject(resourcesObj);
        }
        StreamPane streamPane = new StreamPane(stream, isContentStream, isThumb, resourcesDic);
        this.replaceRightComponent(streamPane.getPanel());
    }

    private void showFont(Object selectedNode, TreePath path) {
        COSDictionary resourceDic;
        COSName fontName = this.getNodeKey(selectedNode);
        FontEncodingPaneController fontEncodingPaneController = new FontEncodingPaneController(fontName, resourceDic = (COSDictionary)this.getUnderneathObject(path.getParentPath().getParentPath().getLastPathComponent()));
        JPanel pane = fontEncodingPaneController.getPane();
        if (pane == null) {
            this.replaceRightComponent(this.jScrollPane2);
            return;
        }
        this.replaceRightComponent(pane);
    }

    private void replaceRightComponent(Component pane) {
        int div = this.jSplitPane1.getDividerLocation();
        this.jSplitPane1.setRightComponent(pane);
        this.jSplitPane1.setDividerLocation(div);
    }

    private void showString(Object selectedNode) {
        COSString string = (COSString)this.getUnderneathObject(selectedNode);
        this.replaceRightComponent(new StringPane(string).getPane());
    }

    private COSName getNodeKey(Object selectedNode) {
        if (selectedNode instanceof MapEntry) {
            return ((MapEntry)selectedNode).getKey();
        }
        return null;
    }

    private Object getUnderneathObject(Object selectedNode) {
        if (selectedNode instanceof MapEntry) {
            selectedNode = ((MapEntry)selectedNode).getValue();
        } else if (selectedNode instanceof ArrayEntry) {
            selectedNode = ((ArrayEntry)selectedNode).getValue();
        } else if (selectedNode instanceof PageEntry) {
            selectedNode = ((PageEntry)selectedNode).getDict();
        }
        if (selectedNode instanceof COSObject) {
            selectedNode = ((COSObject)selectedNode).getObject();
        }
        return selectedNode;
    }

    private String convertToString(Object selectedNode) {
        String data = null;
        if (selectedNode instanceof COSBoolean) {
            data = "" + ((COSBoolean)selectedNode).getValue();
        } else if (selectedNode instanceof COSFloat) {
            data = "" + ((COSFloat)selectedNode).floatValue();
        } else if (selectedNode instanceof COSNull) {
            data = "null";
        } else if (selectedNode instanceof COSInteger) {
            data = "" + ((COSInteger)selectedNode).intValue();
        } else if (selectedNode instanceof COSName) {
            data = "" + ((COSName)selectedNode).getName();
        } else if (selectedNode instanceof COSString) {
            String text = ((COSString)selectedNode).getString();
            for (char c : text.toCharArray()) {
                if (!Character.isISOControl(c)) continue;
                text = "<" + ((COSString)selectedNode).toHexString() + ">";
                break;
            }
            data = "" + text;
        } else if (selectedNode instanceof COSStream) {
            try {
                int amountRead;
                COSStream stream = (COSStream)selectedNode;
                COSInputStream ioStream = stream.createInputStream();
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((amountRead = ((InputStream)ioStream).read(buffer, 0, buffer.length)) != -1) {
                    byteArray.write(buffer, 0, amountRead);
                }
                data = byteArray.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (selectedNode instanceof MapEntry) {
            data = this.convertToString(((MapEntry)selectedNode).getValue());
        } else if (selectedNode instanceof ArrayEntry) {
            data = this.convertToString(((ArrayEntry)selectedNode).getValue());
        }
        return data;
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.document != null) {
            try {
                this.document.close();
                if (!this.currentFilePath.startsWith("http")) {
                    this.recentFiles.addFile(this.currentFilePath);
                }
                this.recentFiles.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.exit(0);
    }

    private void printMenuItemActionPerformed(ActionEvent evt) {
        if (this.document != null) {
            try {
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPageable(new PDFPageable(this.document));
                if (job.printDialog()) {
                    job.print();
                }
            }
            catch (PrinterException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void exitForm(WindowEvent evt) {
        if (this.document != null) {
            try {
                this.document.close();
                if (!this.currentFilePath.startsWith("http")) {
                    this.recentFiles.addFile(this.currentFilePath);
                }
                this.recentFiles.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        File file;
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                new ErrorDialog(throwable).setVisible(true);
            }
        });
        String filename = null;
        String password = "";
        boolean viewPages = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFDebugger.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(VIEW_STRUCTURE)) {
                viewPages = false;
                continue;
            }
            filename = args[i];
        }
        PDFDebugger viewer = new PDFDebugger(viewPages);
        if (filename != null && (file = new File(filename)).exists()) {
            viewer.readPDFFile(filename, password);
        }
        viewer.setVisible(true);
    }

    private void readPDFFile(String filePath, String password) throws IOException {
        File file = new File(filePath);
        this.readPDFFile(file, password);
    }

    private void readPDFFile(File file, String password) throws IOException {
        if (this.document != null) {
            this.document.close();
            if (!this.currentFilePath.startsWith("http")) {
                this.recentFiles.addFile(this.currentFilePath);
            }
        }
        this.currentFilePath = file.getPath();
        this.recentFiles.removeFile(file.getPath());
        this.parseDocument(file, password);
        this.initTree();
        if (IS_MAC_OS) {
            this.setTitle(file.getName());
            this.getRootPane().putClientProperty("Window.documentFile", file);
        } else {
            this.setTitle("PDF Debugger - " + file.getAbsolutePath());
        }
        this.addRecentFileItems();
    }

    private void readPDFurl(String urlString, String password) throws IOException {
        if (this.document != null) {
            this.document.close();
            if (!this.currentFilePath.startsWith("http")) {
                this.recentFiles.addFile(this.currentFilePath);
            }
        }
        this.currentFilePath = urlString;
        URL url = new URL(urlString);
        this.document = PDDocument.load(url.openStream(), password);
        this.initTree();
        if (IS_MAC_OS) {
            this.setTitle(urlString);
        } else {
            this.setTitle("PDF Debugger - " + urlString);
        }
        this.addRecentFileItems();
    }

    private void initTree() {
        TreeStatus treeStatus = new TreeStatus(this.document.getDocument().getTrailer());
        this.statusPane.updateTreeStatus(treeStatus);
        if (this.isPageMode) {
            File file = new File(this.currentFilePath);
            DocumentEntry documentEntry = new DocumentEntry(this.document, file.getName());
            ZoomMenu.getInstance().resetZoom();
            this.tree.setModel(new PDFTreeModel(documentEntry));
            this.tree.setSelectionPath(this.tree.getPathForRow(1));
        } else {
            this.tree.setModel(new PDFTreeModel(this.document));
            this.tree.setSelectionPath(treeStatus.getPathForString("Root"));
        }
    }

    private void parseDocument(File file, String password) throws IOException {
        while (true) {
            try {
                this.document = PDDocument.load(file, password);
            }
            catch (InvalidPasswordException ipe) {
                JPanel panel = new JPanel();
                JLabel label = new JLabel("Password:");
                JPasswordField pass = new JPasswordField(10);
                panel.add(label);
                panel.add(pass);
                Object[] options = new String[]{"OK", "Cancel"};
                int option = JOptionPane.showOptionDialog(null, panel, "Enter password", 1, -1, null, options, "");
                if (option == 0) {
                    password = new String(pass.getPassword());
                    continue;
                }
                throw ipe;
            }
            break;
        }
        this.printMenuItem.setEnabled(true);
    }

    private void addRecentFileItems() {
        AbstractAction recentMenuAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String filePath = (String)((JComponent)actionEvent.getSource()).getClientProperty("path");
                try {
                    PDFDebugger.this.readPDFFile(filePath, "");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        if (!this.recentFiles.isEmpty()) {
            this.recentFilesMenu.removeAll();
            List<String> files = this.recentFiles.getFiles();
            for (int i = files.size() - 1; i >= 0; --i) {
                String path = files.get(i);
                String name = new File(path).getName();
                JMenuItem recentFileMenuItem = new JMenuItem(name);
                recentFileMenuItem.putClientProperty("path", path);
                recentFileMenuItem.addActionListener(recentMenuAction);
                this.recentFilesMenu.add(recentFileMenuItem);
            }
            this.recentFilesMenu.setEnabled(true);
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar PDFDebugger [options] <inputfile>\n\nOptions:\n  -password <password> : Password to decrypt the document\n  -viewstructure       : activate structure mode on startup\n  <inputfile>          : The PDF document to be loaded\n";
        System.err.println(message);
        System.exit(1);
    }
}

