/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;

public class ZephyrUtil {
    public static final String BR = System.getProperty("line.separator");
    public static final HashMap<Character, String> uniChMap = new HashMap();
    public static final String SHIFT_JIS_CODE = "Windows-31J";
    public static final Charset SHIFT_JIS;
    public static final String JIS_CODE = "ISO2022JP";

    static {
        uniChMap.put(Character.valueOf('\u0100'), "A");
        uniChMap.put(Character.valueOf('\u0101'), "a");
        uniChMap.put(Character.valueOf('\u0102'), "A");
        uniChMap.put(Character.valueOf('\u0103'), "a");
        uniChMap.put(Character.valueOf('\u0103'), "a");
        uniChMap.put(Character.valueOf('\u0112'), "E");
        uniChMap.put(Character.valueOf('\u0113'), "e");
        uniChMap.put(Character.valueOf('\u0114'), "E");
        uniChMap.put(Character.valueOf('\u0115'), "e");
        uniChMap.put(Character.valueOf('\u012a'), "I");
        uniChMap.put(Character.valueOf('\u012b'), "i");
        uniChMap.put(Character.valueOf('\u012c'), "I");
        uniChMap.put(Character.valueOf('\u012d'), "i");
        uniChMap.put(Character.valueOf('\u014c'), "O");
        uniChMap.put(Character.valueOf('\u014d'), "o");
        uniChMap.put(Character.valueOf('\u014e'), "O");
        uniChMap.put(Character.valueOf('\u014f'), "o");
        uniChMap.put(Character.valueOf('\u016a'), "U");
        uniChMap.put(Character.valueOf('\u016b'), "u");
        uniChMap.put(Character.valueOf('\u016c'), "U");
        uniChMap.put(Character.valueOf('\u016d'), "u");
        uniChMap.put(Character.valueOf('\u0232'), "Y");
        uniChMap.put(Character.valueOf('\u0233'), "y");
        uniChMap.put(Character.valueOf('\u02d8'), "");
        uniChMap.put(Character.valueOf('\u00c0'), "A");
        uniChMap.put(Character.valueOf('\u00c1'), "A");
        uniChMap.put(Character.valueOf('\u00c2'), "A");
        uniChMap.put(Character.valueOf('\u00c3'), "A");
        uniChMap.put(Character.valueOf('\u00c4'), "A");
        uniChMap.put(Character.valueOf('\u00c6'), "AE");
        uniChMap.put(Character.valueOf('\u0152'), "OE");
        uniChMap.put(Character.valueOf('\u00c7'), "C");
        uniChMap.put(Character.valueOf('\u00c8'), "E");
        uniChMap.put(Character.valueOf('\u00c9'), "E");
        uniChMap.put(Character.valueOf('\u00ca'), "E");
        uniChMap.put(Character.valueOf('\u00cb'), "E");
        uniChMap.put(Character.valueOf('\u00cc'), "I");
        uniChMap.put(Character.valueOf('\u00cd'), "I");
        uniChMap.put(Character.valueOf('\u00cf'), "I");
        uniChMap.put(Character.valueOf('\u00ce'), "I");
        uniChMap.put(Character.valueOf('\u00d0'), "D");
        uniChMap.put(Character.valueOf('\u00d1'), "N");
        uniChMap.put(Character.valueOf('\u00d2'), "O");
        uniChMap.put(Character.valueOf('\u00d3'), "O");
        uniChMap.put(Character.valueOf('\u00d4'), "O");
        uniChMap.put(Character.valueOf('\u00d5'), "O");
        uniChMap.put(Character.valueOf('\u00d6'), "O");
        uniChMap.put(Character.valueOf('\u00d8'), "O");
        uniChMap.put(Character.valueOf('\u00d9'), "U");
        uniChMap.put(Character.valueOf('\u00da'), "U");
        uniChMap.put(Character.valueOf('\u00db'), "U");
        uniChMap.put(Character.valueOf('\u00dc'), "U");
        uniChMap.put(Character.valueOf('\u00dd'), "Y");
        uniChMap.put(Character.valueOf('\u00e0'), "a");
        uniChMap.put(Character.valueOf('\u00e1'), "a");
        uniChMap.put(Character.valueOf('\u00e2'), "a");
        uniChMap.put(Character.valueOf('\u00e3'), "a");
        uniChMap.put(Character.valueOf('\u00e4'), "a");
        uniChMap.put(Character.valueOf('\u00e5'), "a");
        uniChMap.put(Character.valueOf('\u00e6'), "ae");
        uniChMap.put(Character.valueOf('\u0153'), "oe");
        uniChMap.put(Character.valueOf('\u00e7'), "c");
        uniChMap.put(Character.valueOf('\u00e8'), "e");
        uniChMap.put(Character.valueOf('\u00e9'), "e");
        uniChMap.put(Character.valueOf('\u00ea'), "e");
        uniChMap.put(Character.valueOf('\u00eb'), "e");
        uniChMap.put(Character.valueOf('\u00ec'), "i");
        uniChMap.put(Character.valueOf('\u00ed'), "i");
        uniChMap.put(Character.valueOf('\u00ee'), "i");
        uniChMap.put(Character.valueOf('\u00ef'), "i");
        uniChMap.put(Character.valueOf('\u00f1'), "n");
        uniChMap.put(Character.valueOf('\u00f2'), "o");
        uniChMap.put(Character.valueOf('\u00f3'), "o");
        uniChMap.put(Character.valueOf('\u00f4'), "o");
        uniChMap.put(Character.valueOf('\u00f5'), "o");
        uniChMap.put(Character.valueOf('\u00f6'), "o");
        uniChMap.put(Character.valueOf('\u00f8'), "o");
        uniChMap.put(Character.valueOf('\u00f9'), "u");
        uniChMap.put(Character.valueOf('\u00fa'), "u");
        uniChMap.put(Character.valueOf('\u00fb'), "u");
        uniChMap.put(Character.valueOf('\u00fc'), "u");
        uniChMap.put(Character.valueOf('\u00fd'), "y");
        uniChMap.put(Character.valueOf('\u00ff'), "y");
        uniChMap.put(Character.valueOf('\u1e6d'), "t");
        uniChMap.put(Character.valueOf('\u01d3'), "U");
        uniChMap.put(Character.valueOf('\u010c'), "C");
        uniChMap.put(Character.valueOf('\u0160'), "S");
        uniChMap.put(Character.valueOf('\u017d'), "Z");
        uniChMap.put(Character.valueOf('\u01ce'), "a");
        uniChMap.put(Character.valueOf('\u010d'), "c");
        uniChMap.put(Character.valueOf('\u011b'), "e");
        uniChMap.put(Character.valueOf('\u013e'), "I");
        uniChMap.put(Character.valueOf('\u0148'), "n");
        uniChMap.put(Character.valueOf('\u0159'), "r");
        uniChMap.put(Character.valueOf('\u0161'), "s");
        uniChMap.put(Character.valueOf('\u017e'), "z");
        uniChMap.put(Character.valueOf('\u1e35'), "k");
        uniChMap.put(Character.valueOf('\u1e6f'), "t");
        uniChMap.put(Character.valueOf('\u0105'), "a");
        uniChMap.put(Character.valueOf('\u0119'), "e");
        uniChMap.put(Character.valueOf('\u01eb'), "o");
        uniChMap.put(Character.valueOf('\u015f'), "s");
        uniChMap.put(Character.valueOf('\u0163'), "t");
        uniChMap.put(Character.valueOf('\u0106'), "C");
        uniChMap.put(Character.valueOf('\u015a'), "S");
        uniChMap.put(Character.valueOf('\u0107'), "c");
        uniChMap.put(Character.valueOf('\u015b'), "s");
        uniChMap.put(Character.valueOf('\u017a'), "z");
        uniChMap.put(Character.valueOf('\u0287'), "t");
        uniChMap.put(Character.valueOf('\u0189'), "D");
        uniChMap.put(Character.valueOf('\u0111'), "d");
        uniChMap.put(Character.valueOf('\u0141'), "L");
        uniChMap.put(Character.valueOf('i'), "i");
        uniChMap.put(Character.valueOf('\u0142'), "l");
        uniChMap.put(Character.valueOf('\u0151'), "o");
        uniChMap.put(Character.valueOf('\u00c5'), "A");
        uniChMap.put(Character.valueOf('\u1e24'), "H");
        uniChMap.put(Character.valueOf('\u1e62'), "S");
        uniChMap.put(Character.valueOf('\u1e6c'), "T");
        uniChMap.put(Character.valueOf('\u1e0d'), "d");
        uniChMap.put(Character.valueOf('\u1e25'), "h");
        uniChMap.put(Character.valueOf('\u1e33'), "k");
        uniChMap.put(Character.valueOf('\u1e43'), "m");
        uniChMap.put(Character.valueOf('\u1e47'), "n");
        uniChMap.put(Character.valueOf('\u1e5b'), "r");
        uniChMap.put(Character.valueOf('\u1e63'), "s");
        uniChMap.put(Character.valueOf('\u1e93'), "z");
        uniChMap.put(Character.valueOf('\u0130'), "I");
        uniChMap.put(Character.valueOf('\u017b'), "Z");
        uniChMap.put(Character.valueOf('\u0117'), "e");
        uniChMap.put(Character.valueOf('\u0121'), "g");
        uniChMap.put(Character.valueOf('\u1e41'), "m");
        uniChMap.put(Character.valueOf('\u1e45'), "n");
        uniChMap.put(Character.valueOf('\u0127'), "h");
        uniChMap.put(Character.valueOf('S'), "S");
        uniChMap.put(Character.valueOf('\u01d4'), "u");
        uniChMap.put(Character.valueOf('\u1d01'), "AE");
        uniChMap.put(Character.valueOf('\u00f0'), "th");
        uniChMap.put(Character.valueOf('\u00fe'), "th");
        uniChMap.put(Character.valueOf('\u021d'), "g");
        uniChMap.put(Character.valueOf('\u00df'), "ss");
        SHIFT_JIS = Charset.forName(SHIFT_JIS_CODE);
    }

    public static String dropMarks(char c) {
        String s = uniChMap.get(Character.valueOf(c));
        if (s != null) {
            return s;
        }
        return Character.toString(c);
    }

    public static String dropMarks(String txt) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            String s = uniChMap.get(Character.valueOf(c));
            if (s != null) {
                sb.append(s);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String dropTailDigit(String word) {
        if (Character.isDigit(word.charAt(word.length() - 1))) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    public static String hex2uni(String txt) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < txt.length()) {
            int k;
            char c = txt.charAt(i);
            if (c == '&' && txt.substring(i).startsWith("&#x") && (k = txt.indexOf(59, i + 1)) > 0) {
                int code = Integer.parseInt(txt.substring(i + 3, k), 16);
                sb.append((char)code);
                i = k + 1;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String uni2hex(String txt) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < txt.length()) {
            int code = txt.codePointAt(i);
            sb.append("&#x");
            sb.append(String.format("%x", code));
            sb.append(";");
            ++i;
        }
        return sb.toString();
    }

    public static String makeKey(String word, boolean bDropTailDigit) {
        if (bDropTailDigit) {
            word = ZephyrUtil.dropTailDigit(word);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < word.length()) {
            sb.append(ZephyrUtil.dropMarks(word.charAt(i)));
            ++i;
        }
        return sb.toString().toLowerCase();
    }

    public static String makeKey(String word) {
        return ZephyrUtil.makeKey(word, true);
    }

    public static void setShiftJisOuput() {
        try {
            PrintStream p = new PrintStream((OutputStream)System.out, true, SHIFT_JIS_CODE);
            System.setOut(p);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void setUTF8Ouput() {
        try {
            PrintStream p = new PrintStream((OutputStream)System.out, true, "UTF-8");
            System.setOut(p);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String sed(String line, String[][] replaces, String[][] regReplaces) {
        int i;
        if (replaces != null) {
            i = 0;
            while (i < replaces.length) {
                line = line.replace(replaces[i][0], replaces[i][1]);
                ++i;
            }
        }
        if (regReplaces != null) {
            i = 0;
            while (i < regReplaces.length) {
                line = line.replaceAll(regReplaces[i][0], regReplaces[i][1]);
                ++i;
            }
        }
        return line;
    }

    public static void unlimitXMLsize() {
        System.setProperty("jdk.xml.entityExpansionLimit", "0");
    }

    public static String zen2num(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if ('\uff10' <= c && c <= '\uff19') {
                sb.append(c - 65296);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isHiragana(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '\u3041' || '\u309e' < c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isKatakana(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '\u30a1' || '\u30f6' < c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String katakana2hiragana(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if ('\u30a1' <= c && c <= '\u30f6') {
                sb.append((char)(c - 12449 + 12353));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isValidJISCode(int code) {
        char[] chars = Character.toChars(code);
        String s = new String(chars);
        try {
            byte[] jis = s.getBytes(JIS_CODE);
            String s2 = new String(jis, JIS_CODE);
            return s.equals(s2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }
}

