/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EBWinMap {
    private final HashMap<String, String> map = new HashMap();
    private static final Pattern MAP = Pattern.compile("[hz]([0-9A-Z]+)\t([u0-9A-F,]+)");

    public EBWinMap(String filename) throws Exception {
        this.load(filename);
    }

    private void load(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Matcher m = MAP.matcher(line);
            if (!m.find()) continue;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = m.group(2).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                char c = (char)Integer.parseInt(code.substring(1), 16);
                sb.append(c);
                ++n2;
            }
            String ebcode = m.group(1);
            String replace = sb.toString();
            this.map.put(ebcode.toUpperCase(), replace);
        }
        br.close();
        System.err.println("load " + this.map.size() + " gaiji map from " + filename);
    }

    public String replace(String code) {
        return this.map.get(code);
    }
}

