/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import zephyr.util.ImageConverter;

public class MakeImages {
    private static final int BLKSIZE = 2048;
    private static final int MAX_IMAGE_SIZE = 0x100000;
    private final byte[] header = new byte[8];
    private final byte[] buffer = new byte[0x100000];
    public static final Pattern SINGLE_IMAGE = Pattern.compile("<1F4D><0000><0000><x=0,y=0><w=0,h=0>\\[0*([0-9A-F]+):0*([0-9A-F]+)\\]([^<]*)<1F6D>");
    private File tmpFile;

    private int byte2int(byte b) {
        return b & 0xFF;
    }

    private void makeImage(RandomAccessFile honIn, int pos, File outFile, int scalling) throws Exception {
        honIn.seek(pos);
        int readlen = honIn.read(this.header, 0, this.header.length);
        if (readlen != this.header.length) {
            System.err.printf("cannot read header from %X\n", pos);
            return;
        }
        if (this.header[0] != 100 || this.header[1] != 97 || this.header[2] != 116 || this.header[3] != 97) {
            System.err.printf("invalid header at %X\n", pos);
            return;
        }
        int filelen = (this.byte2int(this.header[7]) << 24) + (this.byte2int(this.header[6]) << 16) + (this.byte2int(this.header[5]) << 8) + this.byte2int(this.header[4]);
        honIn.seek(pos + this.header.length);
        readlen = honIn.read(this.buffer, 0, filelen);
        if (readlen != filelen) {
            System.err.printf("cannot read filedata from %X\n", pos);
            return;
        }
        if (scalling == 100) {
            FileOutputStream fo = new FileOutputStream(outFile);
            fo.write(this.buffer, 0, filelen);
            fo.close();
            return;
        }
        FileOutputStream fo = new FileOutputStream(this.tmpFile);
        fo.write(this.buffer, 0, filelen);
        fo.close();
        BufferedImage inImage = ImageIO.read(this.tmpFile);
        int width = scalling * inImage.getWidth() / 100;
        int height = scalling * inImage.getHeight() / 100;
        BufferedImage outImage = ImageConverter.resize(inImage, width, height);
        ImageIO.write((RenderedImage)outImage, "bmp", outFile);
    }

    private static int calcPos(String blkno, String offset) {
        return (Integer.parseInt(blkno, 16) - 1) * 2048 + Integer.parseInt(offset, 16);
    }

    private static String pos2filename(int pos) {
        return String.format("%08X.bmp", pos);
    }

    public static String pos2filename(String blkno, String offset) {
        return MakeImages.pos2filename(MakeImages.calcPos(blkno, offset));
    }

    private void load(File epwTxt, File honmon, File outDir, int scalling) throws Exception {
        String line;
        BufferedReader epwBr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(epwTxt), "Windows-31J"));
        RandomAccessFile honIn = new RandomAccessFile(honmon, "r");
        outDir.mkdirs();
        this.tmpFile = new File(outDir, "original.bmp");
        int nFile = 0;
        while ((line = epwBr.readLine()) != null) {
            Matcher m = SINGLE_IMAGE.matcher(line);
            if (!m.find()) continue;
            int pos = MakeImages.calcPos(m.group(1), m.group(2));
            File outFile = new File(outDir, MakeImages.pos2filename(pos));
            this.makeImage(honIn, pos, outFile, scalling);
            if (++nFile % 100 != 0) continue;
            if (nFile % 1000 == 0) {
                System.err.print(nFile / 1000);
                continue;
            }
            System.err.print(".");
        }
        this.tmpFile.delete();
        honIn.close();
        epwBr.close();
    }

    public static void main(String[] args) throws Exception {
        String epwTxtName = args.length > 0 ? args[0] : "kangorin.txt";
        String honmonName = args.length > 1 ? args[1] : "HONMON";
        String outDirName = args.length > 2 ? args[2] : "g";
        int scalling = args.length > 3 ? Integer.parseInt(args[3]) : 100;
        MakeImages app = new MakeImages();
        app.load(new File(epwTxtName), new File(honmonName), new File(outDirName), scalling);
    }
}

