/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.nio.charset.Charset;

public class JISTable {
    private static int byte2int(byte b) {
        return b & 0xFF;
    }

    private static void dumpJIS(String s) throws Exception {
        byte[] jis = s.getBytes("ISO-2022-JP");
        System.out.printf("%s\t%x.%x.%x.(%d:%d).%x.%x.%x\n", s, jis[0], jis[1], jis[2], JISTable.byte2int(jis[3]) - 32, JISTable.byte2int(jis[4]) - 32, jis[5], jis[6], jis[7]);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Charset.availableCharsets().keySet());
        JISTable.dumpJIS("\u4ff1");
        JISTable.dumpJIS("\ud840\udc0b");
        JISTable.dumpJIS("\u3402");
        JISTable.dumpJIS("\u4e28");
        JISTable.dumpJIS("\ud840\udc89");
        JISTable.dumpJIS("\u4e02");
        JISTable.dumpJIS("\u4e0f");
        System.out.print("\t");
        byte[] byArray = new byte[8];
        byArray[0] = 27;
        byArray[1] = 36;
        byArray[2] = 66;
        byArray[5] = 27;
        byArray[6] = 40;
        byArray[7] = 66;
        byte[] jisdata = byArray;
        byte ten = 1;
        while (ten <= 94) {
            System.out.printf("%02d ", ten);
            if (ten % 16 == 0) {
                System.out.println();
                System.out.print("\t");
            }
            ten = (byte)(ten + 1);
        }
        System.out.println();
        int ku = 16;
        while (ku <= 83) {
            jisdata[3] = (byte)(ku + 32);
            System.out.print(String.valueOf(ku) + "\t");
            int ten2 = 1;
            while (ten2 <= 94) {
                jisdata[4] = (byte)(ten2 + 32);
                String t = new String(jisdata, "ISO2022JP");
                System.out.print(String.valueOf(t) + " ");
                if (ten2 % 16 == 0) {
                    System.out.println();
                    System.out.print("\t");
                }
                ten2 = (byte)(ten2 + 1);
            }
            System.out.println();
            ku = (byte)(ku + 1);
        }
    }
}

