/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.MultiHashMap;

public class IndexManager {
    private final MultiHashMap<String, String> idx2hyokiMap = new MultiHashMap();
    private final MultiHashMap<String, String> idx2kanaMap = new MultiHashMap();
    private static final Pattern HYOKI_LINE = Pattern.compile("^(.+?)\\[[0-9]+\\]\t\\[0*([0-9A-F]+):0*([0-9A-F]+)\\]");
    private static final Pattern KANA_LINE = Pattern.compile("^C0:([^\\[]+)\\[[0-9]+\\]\t\\[0*([0-9A-F]+):(0*[0-9A-F]+)\\]");

    public IndexManager(String hyokiFile, String kanaFile) throws Exception {
        this.loadHyoki(hyokiFile);
        this.loadKana(kanaFile);
    }

    private String makeIndex(String high, String low) {
        switch (low.length()) {
            case 1: {
                return String.valueOf(high) + "00" + low;
            }
            case 2: {
                return String.valueOf(high) + "0" + low;
            }
            case 3: {
                return String.valueOf(high) + low;
            }
        }
        System.err.println("invalid high:low " + high + ":" + low);
        return "";
    }

    private void loadHyoki(String kanaFile) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(kanaFile));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        while ((line = br.readLine()) != null) {
            String hyoki;
            Matcher m = HYOKI_LINE.matcher(line);
            if (!m.find() || (hyoki = m.group(1)).matches("[\uff10-\uff19]+")) continue;
            String index = this.makeIndex(m.group(2), m.group(3));
            if (index.startsWith("0")) {
                System.err.println("invalid idx: " + m.group());
                System.exit(1);
            }
            this.idx2hyokiMap.put(index, hyoki);
        }
        br.close();
        System.err.println("load " + this.idx2hyokiMap.size() + " from " + kanaFile);
    }

    private void loadKana(String hyokiFile) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(hyokiFile));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        while ((line = br.readLine()) != null) {
            Matcher m = KANA_LINE.matcher(line);
            if (!m.find()) continue;
            String kana = m.group(1);
            String index = this.makeIndex(m.group(2), m.group(3));
            this.idx2kanaMap.put(index, kana);
        }
        br.close();
        System.err.println("load " + this.idx2kanaMap.size() + " from " + hyokiFile);
    }

    public String getKey(String idx) {
        LinkedList hyokiList = this.idx2hyokiMap.getWithoutNull(idx);
        LinkedList kanaList = this.idx2kanaMap.getWithoutNull(idx);
        if (hyokiList.isEmpty() && kanaList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String hyoki : hyokiList) {
            sb.append("<key type=\"\u8868\u8a18\">");
            sb.append(hyoki);
            sb.append("</key>");
        }
        for (String kana : kanaList) {
            sb.append("<key type=\"\u304b\u306a\">");
            sb.append(kana);
            sb.append("</key>");
        }
        return sb.toString();
    }
}

