/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.taishukan.kangorin.MakeBodyHtml;

public class GaijiFinder {
    private final HashMap<String, String> jisx2chMap = new HashMap();
    private final HashMap<String, String> sjis2chMap = new HashMap();
    private final HashMap<String, String> hojo2chMap = new HashMap();
    private static final Pattern MIDASHI_OYA = Pattern.compile("<1F09><0002><1F41><0160>\u3010<([0-9A-F]+{4})>\u3011<1F61><1F0A>");
    private static final Pattern MIDASHI_KYUUJI = Pattern.compile("<1F09><0031><([0-9A-F]+{4})><1F0A>");
    private static final Pattern KANJI_CODE = Pattern.compile("<1F09><00(24|37)>(.+)<1F0A>");

    private void loadJISX(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] v = line.split("\t");
            String uni = v[0];
            String jisx = String.valueOf(v[1].substring(0, 4)) + v[1].substring(5);
            String sjis = v[2];
            this.jisx2chMap.put(jisx, uni);
            this.sjis2chMap.put(sjis, uni);
        }
        br.close();
    }

    private void loadHojo(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] v = line.split("\t");
            String uni = v[0];
            String hojo = v[1];
            this.hojo2chMap.put(hojo, uni);
        }
        br.close();
    }

    private void out(String kanji, String codeTxt, String uni) {
        if (uni != null) {
            System.out.println(String.valueOf(kanji) + "\t" + codeTxt + "\t" + uni + "\t" + String.format("%04X", uni.codePointAt(0)));
        } else {
            System.out.println(String.valueOf(kanji) + "\t" + codeTxt);
        }
    }

    private void parse(String kanji, String codeTxt) {
        codeTxt = codeTxt.replaceAll("<[0-9A-F]+{4}>", "");
        String[] v = (codeTxt = MakeBodyHtml.zen2han(codeTxt)).split("\\|");
        if (!v[0].equals("\u2015")) {
            this.out(kanji, codeTxt, this.jisx2chMap.get(v[0]));
        } else if (!v[1].equals("\u2015")) {
            this.out(kanji, codeTxt, this.sjis2chMap.get(v[1]));
        } else if (v.length == 3 && !v[2].equals("\u2015")) {
            this.out(kanji, codeTxt, this.hojo2chMap.get(v[2]));
        } else {
            this.out(kanji, codeTxt, null);
        }
    }

    private void load(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        String kanji = null;
        while ((line = br.readLine()) != null) {
            Matcher m;
            if (line.contains("<1F09><0002>") || line.contains("<1F09><0031>") || line.contains("<1F09><0090>")) {
                kanji = null;
            }
            if ((m = MIDASHI_OYA.matcher(line)).find()) {
                kanji = m.group(1);
                continue;
            }
            m = MIDASHI_KYUUJI.matcher(line);
            if (m.find()) {
                kanji = m.group(1);
                continue;
            }
            if (kanji == null || !(m = KANJI_CODE.matcher(line)).find()) continue;
            this.parse(kanji, m.group(2));
        }
        br.close();
    }

    public static void main(String[] args) throws Exception {
        GaijiFinder app = new GaijiFinder();
        String kangorin = args.length > 0 ? args[0] : "kangorin.txt";
        String jisx = args.length > 1 ? args[1] : "jisxtable.txt";
        String hojo = args.length > 2 ? args[2] : "hojotable.txt";
        app.loadJISX(jisx);
        app.loadHojo(hojo);
        app.load(kangorin);
    }
}

