/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDF2BMPPage {
    private void convert(File pdfFile, File outDir, int startPage, int endPage, int dpi) throws Exception {
        if (!pdfFile.exists()) {
            System.err.println(pdfFile + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        System.out.println(String.valueOf(pdfFile.getName()) + " \u5909\u63db\u958b\u59cb");
        PDDocument document = PDDocument.load((File)pdfFile);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        int nPages = endPage - startPage + 1;
        int i = 1;
        while (i <= nPages) {
            BufferedImage bim = pdfRenderer.renderImageWithDPI(startPage + i - 1, (float)dpi, ImageType.BINARY);
            File outputfile = new File(outDir, String.format("%04x.bmp", i));
            ImageIO.write((RenderedImage)bim, "bmp", outputfile);
            System.out.print(String.valueOf(i) + " ");
            ++i;
        }
        document.close();
        System.out.println();
        System.out.println(String.valueOf(pdfFile.getName()) + " \u5909\u63db\u7d42\u4e86");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Usage: java PDF2BMPPage file.pdf outDir startPage endPage [dpi]");
            return;
        }
        String pdfName = args[0];
        String outDirName = args[1];
        int startPage = Integer.parseInt(args[2]);
        int endPage = Integer.parseInt(args[3]);
        int dpi = args.length >= 5 ? Integer.parseInt(args[4]) : 200;
        PDF2BMPPage app = new PDF2BMPPage();
        app.convert(new File(pdfName), new File(outDirName), startPage, endPage, dpi);
    }
}

