/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.util.HashMap;
import java.util.TreeSet;
import zephyr.sanshusha.accessdejp.Buffer;
import zephyr.sanshusha.accessdejp.Util;

public class TagDecoder {
    private static final HashMap<Integer, String> tagMap = new HashMap();
    private static final int ZENKAKU_START = -515491792;
    private static final int HANKAKU_START = -515493840;
    private static final int EXTCHAR_START = -515493838;
    private static final int YOUREI_START = -515099638;
    private static final int WAKU_START = 14767692;
    static final String WAKU_START_TAG = "<WAKU_START/>";
    static final String WAKU_END_TAG = "<WAKU_END/>";
    static final String SECTION_TAG = "<SECTION/>";
    static final String SUBSECTION_TAG = "<SUBSECTION/>";
    private static final HashMap<Integer, String> uniMap;
    private static final HashMap<Integer, String> extChMap;
    private static final TreeSet<Character> unknownExChar;
    private static byte BYTE_E1;

    static {
        tagMap.put(-515491792, "");
        tagMap.put(-515493840, "");
        tagMap.put(-515493838, "");
        tagMap.put(14762545, "<b>");
        tagMap.put(14762544, "</b>");
        tagMap.put(14764337, "<i>");
        tagMap.put(14764336, "</i>");
        tagMap.put(14765105, SECTION_TAG);
        tagMap.put(14765106, SUBSECTION_TAG);
        tagMap.put(14765107, "");
        tagMap.put(14766898, "");
        tagMap.put(14766899, "");
        tagMap.put(14767692, WAKU_START_TAG);
        tagMap.put(14767724, WAKU_END_TAG);
        tagMap.put(14775089, "<sub>");
        tagMap.put(14775088, "</sub>");
        uniMap = new HashMap();
        char c = '\u00c0';
        while (c <= '\u00ff') {
            uniMap.put(Integer.valueOf(c), Character.toString(c));
            c = (char)(c + '\u0001');
        }
        extChMap = new HashMap();
        extChMap.put(33, "\u0301");
        extChMap.put(TagDecoder.str2int("A~"), "\u00e0");
        extChMap.put(TagDecoder.str2int("a!"), "\u00e1");
        extChMap.put(TagDecoder.str2int("e!"), "\u00e9");
        extChMap.put(TagDecoder.str2int("I!"), "\u026a\u0301");
        extChMap.put(37409, "\u026a\u0301");
        extChMap.put(TagDecoder.str2int("i!"), "\u00ed");
        extChMap.put(TagDecoder.str2int("o!"), "\u00f3");
        extChMap.put(TagDecoder.str2int("u!"), "\u00fa");
        extChMap.put(58158, "\u00f8\u0301");
        extChMap.put(165, "\u035c");
        extChMap.put(67, "\u00e7");
        extChMap.put(69, "\u0259");
        extChMap.put(103, "\u0261");
        extChMap.put(73, "\u026a");
        extChMap.put(78, "\u014b");
        extChMap.put(79, "\u0254");
        extChMap.put(83, "\u0283");
        extChMap.put(89, "\u028f");
        extChMap.put(123, "\u0153");
        extChMap.put(201, "\u02d0");
        extChMap.put(211, "\u025b");
        extChMap.put(54142, "\u025b\u0300");
        extChMap.put(227, "\u00f8");
        extChMap.put(231, "\u028a");
        extChMap.put(218, "\u0301");
        extChMap.put(90, "\u0292");
        extChMap.put(97, "a");
        extChMap.put(102, "f");
        extChMap.put(112, "p");
        extChMap.put(114, "r");
        extChMap.put(115, "s");
        extChMap.put(116, "t");
        extChMap.put(121, "y");
        unknownExChar = new TreeSet();
        BYTE_E1 = Util.int2sbyte(225);
    }

    private static int bytes2int(byte b0, byte b1) {
        return (Util.sbyte2int(b0) << 8) + Util.sbyte2int(b1);
    }

    private static int str2int(String str) {
        byte[] data = str.getBytes();
        if (data.length == 2) {
            return TagDecoder.bytes2int(data[0], data[1]);
        }
        System.err.println("PROGRAM ERROR: " + str);
        return -1;
    }

    private static int outExtChars(StringBuffer sb, byte[] inData, int start) {
        int i = start;
        while (inData[i] != BYTE_E1) {
            int v0 = Util.sbyte2int(inData[i]);
            int val2 = (v0 << 8) + Util.sbyte2int(inData[i + 1]);
            String ext = extChMap.get(val2);
            if (ext != null) {
                sb.append(ext);
                i += 2;
                continue;
            }
            ext = extChMap.get(v0);
            if (ext != null) {
                sb.append(ext);
                ++i;
                continue;
            }
            char c = (char)v0;
            sb.append(c);
            if (!unknownExChar.contains(Character.valueOf(c))) {
                unknownExChar.add(Character.valueOf(c));
                System.err.println("unknown extChar: " + c + String.format("\t%x %x %x", inData[i - 1], inData[i], inData[i + 1]));
                System.err.println("\t" + sb.toString().replace("\n", " "));
            }
            ++i;
        }
        return i;
    }

    String decode(byte[] inData, int length) {
        int charMode = -515493840;
        Buffer outBuf = new Buffer();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            byte b = inData[i];
            int c = Util.sbyte2int(b);
            if (b != BYTE_E1) {
                if (charMode == -515493840) {
                    String uni = uniMap.get(c);
                    if (uni != null) {
                        sb.append(outBuf.toString(false));
                        outBuf.clear();
                        sb.append(uni);
                    } else if (c == 183) {
                        sb.append(outBuf.toString(false));
                        outBuf.clear();
                        sb.append("\u00b7");
                    } else {
                        outBuf.add(b);
                    }
                } else {
                    outBuf.add(b);
                }
                ++i;
                continue;
            }
            int tag3 = Util.sbyte2int(inData[i]) << 16;
            tag3 += Util.sbyte2int(inData[i + 1]) << 8;
            int tag4 = ((tag3 += Util.sbyte2int(inData[i + 2])) << 8) + Util.sbyte2int(inData[i + 3]);
            switch (tag4) {
                case -515493840: {
                    sb.append(outBuf.toString(true));
                    outBuf.clear();
                    charMode = tag4;
                    i += 4;
                    break;
                }
                case -515491792: {
                    sb.append(outBuf.toString(false));
                    outBuf.clear();
                    charMode = tag4;
                    i += 4;
                    break;
                }
                case -515493838: {
                    sb.append(outBuf.toString(charMode == -515491792));
                    outBuf.clear();
                    i = TagDecoder.outExtChars(sb, inData, i + 4);
                    break;
                }
                case -515099638: {
                    sb.append(outBuf.toString(charMode == -515491792));
                    outBuf.clear();
                    sb.append("\u25b7\n");
                    i += 4;
                    break;
                }
                default: {
                    String tagtxt = tagMap.get(tag3);
                    if (tagtxt != null) {
                        sb.append(outBuf.toString(charMode == -515491792));
                        outBuf.clear();
                        i += 3;
                        if (tag3 == 14767692) {
                            while (inData[i] != BYTE_E1) {
                                ++i;
                            }
                        }
                        outBuf.add(tagtxt);
                        break;
                    }
                    outBuf.add(b);
                    ++i;
                }
            }
        }
        sb.append(outBuf.toString(charMode == -515491792));
        return sb.toString();
    }

    static void dumpUnknown() {
        for (char c : unknownExChar) {
            System.err.print(c);
        }
        if (!unknownExChar.isEmpty()) {
            System.err.println();
        }
    }
}

