/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.oxford.oed.MakeLemmaList;

public class MakeSortedBody {
    private final TreeMap<String, String> entryMap = new TreeMap(new MakeLemmaList.LemmaComp());
    private static final Pattern SECTION = Pattern.compile("^(\u2020?)((([a-zA-Z0-9]+)\\. ([a-zA-Z0-9]+)\\.([a-zA-Z0-9\\.]*?\\4\\.\\5))|([a-zA-Z0-9\\.]+))");

    private String fixSection(String line) {
        Matcher m = SECTION.matcher(line);
        if (m.find()) {
            String head = m.group(7);
            if (head != null) {
                if (!head.contains(".")) {
                    return line;
                }
                head = head.replaceFirst("([a-zA-Z0-9]+)\\.([a-zA-Z0-9\\.]*?\\1)", "<b>$2</b>");
                return String.valueOf(m.group(1)) + head + line.substring(m.end());
            }
            return String.valueOf(m.group(1)) + "<b>" + m.group(6) + "</b>" + line.substring(m.end());
        }
        return line;
    }

    private void addEntry(String dt, LinkedList<String> lines) {
        StringBuilder sb = new StringBuilder();
        boolean blank = false;
        for (String line : lines) {
            if (line.equals(dt)) continue;
            String l = line.trim();
            if (l.isEmpty()) {
                if (sb.length() <= 0 || blank) continue;
                sb.append("<br><br>\n");
                blank = true;
                continue;
            }
            l = this.fixSection(l);
            l = l.replaceAll("(\\xa0+)([ac \\xa0\\u2006]*[0-9\\-]+)", "$1<b>$2</b>");
            sb.append("<p>" + l + "</p>\n");
            blank = false;
        }
        this.entryMap.put(dt, sb.toString());
    }

    private void loadFile(File file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        boolean found = false;
        String dt = null;
        LinkedList<String> lines = new LinkedList<String>();
        while ((line = br.readLine()) != null) {
            if (line.equals("======")) {
                found = false;
                if (!this.entryMap.containsKey(dt)) {
                    this.addEntry(dt, lines);
                }
                lines.clear();
                continue;
            }
            lines.add(line);
            if (found || line.startsWith("Draft entry ") || line.startsWith("Additions ") || line.isEmpty()) continue;
            found = true;
            dt = line;
        }
        br.close();
    }

    private void loadDir(String dirname) throws Exception {
        System.err.println("check " + dirname);
        int i = 0;
        while (i < 50) {
            File f = new File(dirname, "oed-" + i + ".txt");
            if (f.exists()) {
                this.loadFile(f);
            }
            ++i;
        }
    }

    private void output() {
        System.err.println(String.valueOf(this.entryMap.size()) + " entries");
        System.out.println("<html><body>");
        for (Map.Entry<String, String> e : this.entryMap.entrySet()) {
            System.out.print("<dt>");
            System.out.print(e.getKey());
            System.out.println("</dt><dd>");
            System.out.print(e.getValue());
            System.out.println("</dd>");
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] args) throws Exception {
        MakeSortedBody app = new MakeSortedBody();
        if (args.length == 0) {
            File dir = new File("data");
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                app.loadDir("data/" + name);
                ++n2;
            }
        } else {
            app.loadDir(args[0]);
        }
        app.output();
    }
}

