/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import zephyr.util.ZephyrUtil;

public class MakeLemmaList {
    private final TreeMap<String, Integer> lemmas = new TreeMap(new LemmaComp());
    private static final HashSet<Character> ignoreChars = new HashSet();
    private final TreeSet<Character> irregChars = new TreeSet();
    private int[] count = new int[27];
    private final TreeSet<String> headSet = new TreeSet();

    static {
        String ignore = " !\"#$%&'()'-=^~\\|@`[{]};+:*<>,./?_\u2020\u02cc\u02c8\u2016\u2014\u00b6\u2006\u2013\u2018\u2032\u2019";
        int i = 0;
        while (i < ignore.length()) {
            ignoreChars.add(Character.valueOf(ignore.charAt(i)));
            ++i;
        }
    }

    private static String normalize(String line) {
        int idx = line.indexOf(44);
        if (idx > 0) {
            line = line.substring(0, idx);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (!ignoreChars.contains(Character.valueOf(c))) {
                sb.append(c);
            }
            ++i;
        }
        return ZephyrUtil.dropMarks(sb.toString()).toLowerCase().trim();
    }

    private static String headword(String line) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == ',' || c == ' ' || c == '(') {
                if (sb.length() > 0) {
                    break;
                }
            } else if (!ignoreChars.contains(Character.valueOf(c))) {
                sb.append(c);
            }
            ++i;
        }
        String s = ZephyrUtil.dropMarks(sb.toString()).toLowerCase().trim();
        if (!s.matches("^[0-9]+$")) {
            return s.replaceFirst("[0-9]+$", "");
        }
        return s;
    }

    private void addLemma(String line) {
        String lemma = MakeLemmaList.normalize(line);
        if (lemma.length() == 0) {
            return;
        }
        this.lemmas.put(line, 0);
        char c = lemma.charAt(0);
        if ('a' <= c && c <= 'z') {
            int n = c - 97;
            this.count[n] = this.count[n] + 1;
        } else {
            int n = this.count.length - 1;
            this.count[n] = this.count[n] + 1;
        }
        if (lemma.length() >= 2) {
            this.headSet.add(lemma.substring(0, 2));
        } else {
            this.headSet.add(lemma);
        }
        int i = 0;
        while (i < lemma.length()) {
            c = lemma.charAt(i);
            if (!(c >= 'a' && 'z' >= c || c >= '0' && '9' >= c)) {
                this.irregChars.add(Character.valueOf(c));
            }
            ++i;
        }
    }

    private void loadFile(File file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        boolean found = false;
        int size = 0;
        String dt = null;
        while ((line = br.readLine()) != null) {
            if (line.equals("======")) {
                found = false;
                this.lemmas.put(dt, size);
                size = 0;
                continue;
            }
            size += line.length();
            if (found || line.startsWith("Draft entry ") || line.startsWith("Additions ") || line.isEmpty()) continue;
            this.addLemma(line);
            found = true;
            dt = line;
        }
        br.close();
    }

    private void loadDir(String dirname) throws Exception {
        System.err.println("check " + dirname);
        int i = 0;
        while (i < 50) {
            File f = new File(dirname, "oed-" + i + ".txt");
            if (f.exists()) {
                this.loadFile(f);
            }
            ++i;
        }
    }

    private void output() {
        for (Map.Entry<String, Integer> e : this.lemmas.entrySet()) {
            String lemma = e.getKey();
            int size = e.getValue();
            System.out.println(String.valueOf(lemma) + "\t" + MakeLemmaList.headword(lemma) + "\t" + size);
            if (size <= 100000) continue;
            System.err.println(String.valueOf(lemma) + "\t" + size);
        }
        int i = 0;
        while (i < 26) {
            char c0 = (char)(i + 97);
            System.err.println("count[" + c0 + "]=" + this.count[i]);
            System.err.print("\t");
            char c1 = 'a';
            while (c1 <= 'z') {
                if (this.headSet.contains(String.valueOf(Character.toString(c0)) + c1)) {
                    System.err.print(String.valueOf(c1) + " ");
                }
                c1 = (char)(c1 + '\u0001');
            }
            System.err.println();
            ++i;
        }
        System.err.println("count[0]=" + this.count[this.count.length - 1]);
        System.err.println("irregular chars : " + this.irregChars.toString());
        System.err.println(String.valueOf(this.lemmas.size()) + " lemmas");
    }

    public static void main(String[] args) throws Exception {
        MakeLemmaList app = new MakeLemmaList();
        if (args.length == 0) {
            File dir = new File("data");
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                app.loadDir("data/" + name);
                ++n2;
            }
        } else {
            app.loadDir(args[0]);
        }
        app.output();
    }

    static class LemmaComp
    implements Comparator<String> {
        LemmaComp() {
        }

        private String tail(String line) {
            int idx = line.indexOf(44);
            if (idx > 0) {
                return line.substring(idx + 1).trim();
            }
            return null;
        }

        @Override
        public int compare(String o1, String o2) {
            String s2;
            String s1 = MakeLemmaList.normalize(o1);
            int r = s1.compareTo(s2 = MakeLemmaList.normalize(o2));
            if (r != 0) {
                return r;
            }
            s1 = this.tail(o1);
            s2 = this.tail(o2);
            if (s1 != null && s2 != null) {
                return s1.compareTo(s2);
            }
            return o1.compareTo(o2);
        }
    }
}

