/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.util.RefEntry;
import zephyr.util.MultiLinkedHashMap;

public class PDFIndex {
    public static final String INDEX_UTF8_FILENAME = "jpgindex.utf8.html";
    private static final Pattern ENTRY_LINE = Pattern.compile("\t*([^\t]+)\t([0-9]+)-?([0-9]*)");
    protected final HashMap<String, RefEntry> entryMap = new HashMap();

    public void init(File file) throws Exception {
        MultiLinkedHashMap<String, ArrayList<String>> pageMap = this.load(file);
        this.makeJpgIndexHtml(new File(INDEX_UTF8_FILENAME), pageMap);
    }

    private MultiLinkedHashMap<String, ArrayList<String>> load(File file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String prefix = "";
        String[] titles = new String[10];
        MultiLinkedHashMap<String, ArrayList<String>> pageMap = new MultiLinkedHashMap<String, ArrayList<String>>();
        while ((line = br.readLine()) != null) {
            String orgLine = line;
            if ((line = line.trim()).isEmpty()) {
                int i = 0;
                while (i < titles.length) {
                    titles[i] = null;
                    ++i;
                }
                continue;
            }
            if (line.startsWith("*")) {
                String[] v = line.substring(1).split("\t");
                prefix = v[0];
                titles[0] = v[1];
                continue;
            }
            Matcher m = ENTRY_LINE.matcher(line);
            if (m.find()) {
                RefEntry entry = new RefEntry(prefix, m.group(1), m.group(2), m.group(3));
                if (this.entryMap.containsKey(entry.key) && !entry.key.equals("-ir/-oir/-re")) {
                    System.err.println("\u30ad\u30fc\u91cd\u8907\uff1a" + entry.key);
                }
                this.entryMap.put(entry.key, entry);
                this.handleLine(prefix, entry);
                this.setTitles(titles, orgLine, entry.title);
                String[] stringArray = entry.jpgs;
                int n = entry.jpgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String jpg = stringArray[n2];
                    pageMap.put(jpg, this.pageTitle(titles));
                    ++n2;
                }
                continue;
            }
            this.setTitles(titles, orgLine, line);
        }
        br.close();
        return pageMap;
    }

    public void handleLine(String prefix, RefEntry entry) {
    }

    private void setTitles(String[] titles, String orgLine, String line) {
        int i = 0;
        while (i < orgLine.length() && orgLine.charAt(i) == '\t') {
            ++i;
        }
        titles[++i] = line;
        ++i;
        while (i < titles.length) {
            titles[i] = null;
            ++i;
        }
    }

    private ArrayList<String> pageTitle(String[] titles) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(titles[0]);
        int i = 1;
        while (i < titles.length) {
            if (titles[i] == null) break;
            if (!titles[i].equals(titles[i - 1])) {
                list.add(titles[i]);
            }
            ++i;
        }
        return list;
    }

    private void makeHeader(BufferedWriter bw, ArrayList<String> ar, int level, String[] headers) throws IOException {
        String t;
        if (ar.size() > level && !(t = ar.get(level)).isEmpty() && !t.equals(headers[level])) {
            String tag = "h" + (level + 1);
            bw.write("<");
            bw.write(tag);
            bw.write(">");
            bw.write(t);
            bw.write("</");
            bw.write(tag);
            bw.write(">");
            bw.newLine();
            headers[level] = t;
            int i = level + 1;
            while (i < headers.length) {
                headers[i] = "";
                ++i;
            }
        }
    }

    private void makeJpgIndexHtml(File file, MultiLinkedHashMap<String, ArrayList<String>> pageMap) throws Exception {
        FileOutputStream out = new FileOutputStream(file);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        bw.write("<html><body>");
        bw.newLine();
        String[] headers = new String[]{"", "", "", ""};
        ArrayList prevList = new ArrayList();
        for (String jpg : pageMap.keySet()) {
            LinkedList list = pageMap.getList(jpg);
            for (ArrayList ar : list) {
                int level = 0;
                while (level < headers.length) {
                    this.makeHeader(bw, ar, level, headers);
                    ++level;
                }
            }
            bw.write("<dt id=\"");
            bw.write(jpg);
            bw.write("\">");
            if (jpg.startsWith("preface")) {
                bw.write(jpg.replace("preface", "pr\u00e9face"));
            } else if (jpg.startsWith("creole")) {
                bw.write(jpg.replace("creole", "cr\u00e9ole"));
            } else {
                bw.write(jpg);
            }
            bw.write("</dt><dd><p>");
            boolean bFirst = true;
            for (ArrayList title : list) {
                if (!bFirst) {
                    bw.write(", ");
                }
                boolean titleTop = true;
                int i = 0;
                while (i < title.size()) {
                    if (i >= prevList.size() || !((String)prevList.get(i)).equals(title.get(i))) {
                        if (titleTop) {
                            bw.write("\u25cf");
                            titleTop = false;
                        }
                        bw.write((String)title.get(i));
                        if (i < title.size() - 1) {
                            bw.write(" ");
                        }
                    }
                    ++i;
                }
                bFirst = false;
                prevList = title;
            }
            bw.write("</p>");
            bw.newLine();
            bw.write("<p><img src=\"jpg/");
            bw.write(String.valueOf(jpg) + ".jpg");
            bw.write("\"/></p></dd>");
            bw.newLine();
            prevList.clear();
        }
        bw.write("</body></html>");
        bw.newLine();
        bw.close();
    }
}

