/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.royalfrjp.MakeBodyHtml;
import zephyr.util.ZephyrUtil;

public class MakeConjuHtml {
    private static final String MIDASI_REGEXP = "<p class=\"midasi\">(.+?)\uff1a(.+?)</p>";
    private static final String TITLE_REGEXP = "<td class=\"title\">(.+?)</td>";
    private static final String TD_REGEXP = "<td>(.*?)(<br>)?</td>";
    private static final Pattern MIDASI = Pattern.compile("<p class=\"midasi\">(.+?)\uff1a(.+?)</p>");
    private static final Pattern TITLE = Pattern.compile("<td class=\"title\">(.+?)</td>");
    private static final Pattern TD = Pattern.compile("<td>(.*?)(<br>)?</td>");
    private int nLoaded = 0;

    private void loadOneConjuFile(File file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        String lemma = "";
        String id = file.getName().replace(".htm", "").toUpperCase();
        LinkedList<String> titles = new LinkedList<String>();
        while ((line = br.readLine()) != null) {
            Matcher m = MIDASI.matcher(line);
            if (m.find()) {
                if (!lemma.equals(m.group(1))) {
                    if (!lemma.isEmpty()) {
                        System.out.println("</dd>");
                    }
                    System.out.print("<dt id=\"" + id + "\">" + m.group(1) + " #</dt><dd>");
                    lemma = m.group(1);
                }
                System.out.print("<indent val=\"1\"><p><b>== ");
                System.out.print(m.group(2));
                System.out.println(" ==</b></p>");
                if (titles.size() == 0) continue;
                System.err.println("ERROR: titles.size() = " + titles.size());
                System.err.println(line);
                System.exit(1);
                continue;
            }
            m = TITLE.matcher(line);
            if (m.find()) {
                titles.add(m.group(1));
                continue;
            }
            m = TD.matcher(line);
            if (!m.find()) continue;
            String title = (String)titles.poll();
            System.out.print("<indent val=\"1\"><p>-- ");
            System.out.print(title);
            System.out.print(" --</p><indent val=\"2\"><p>");
            String td = m.group(1);
            td = td.length() > 0 ? td.replace("<br>", " / ") : "---";
            System.out.print(td);
            System.out.println("</p>");
        }
        System.out.println("</dd>");
        br.close();
        ((InputStream)in).close();
    }

    private void loadConjuFiles(String dirname, File dir) throws Exception {
        Object[] names = dir.list();
        Arrays.sort(names);
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            File file = new File(dir.getAbsolutePath(), (String)name);
            this.loadOneConjuFile(file);
            ++this.nLoaded;
            if (this.nLoaded % 100 == 0) {
                System.err.print(".");
            }
            ++n2;
        }
    }

    private void loadConjuFiles(String path) throws Exception {
        File dir = new File(path);
        MakeBodyHtml.checkDirectory(dir);
        String dirname = dir.getName();
        System.out.println("<html><body>");
        if (dir.isDirectory()) {
            if (dirname.length() == 1) {
                this.loadConjuFiles(dirname, dir);
            } else {
                char c = 'a';
                while (c <= 'z') {
                    System.err.print(c);
                    dir = new File(path, Character.toString(c));
                    dirname = dir.getName();
                    this.loadConjuFiles(dirname, dir);
                    c = (char)(c + '\u0001');
                }
            }
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + this.nLoaded + " entries");
    }

    public static void main(String[] args) {
        ZephyrUtil.setShiftJisOuput();
        MakeConjuHtml app = new MakeConjuHtml();
        if (args.length > 0) {
            try {
                app.loadConjuFiles(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeConjuHtml <SOME_DIR>/royal/contents/fr/conju{/[a-z]}");
        }
    }
}

