/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendLatinKeys;
import zephyr.util.ZephyrUtil;

public class SedBodyHtml {
    private static final String DT_ID_REGEXP = "<dt[^>]+>(<b>\\** *)?(.+?)(</b>)?</dt>";
    private static final Pattern DT_ID = Pattern.compile("<dt[^>]+>(<b>\\** *)?(.+?)(</b>)?</dt>");
    private static final String YKG_REGEXP = "<ykg>(.*?)</ykg>";
    private static final Pattern YKG = Pattern.compile("<ykg>(.*?)</ykg>");
    private static final String YKG_BOLD_REGEXP = "<b>\uff65*(.*?)</b>";
    private static final Pattern YKG_BOLD = Pattern.compile("<b>\uff65*(.*?)</b>");
    private static final AppendLatinKeys LATKEY = new AppendLatinKeys();
    private static int nJPKey = 0;
    private static final String[][] REPLACES = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;amp;", "&"}, {"&amp;", "&"}, {"&hellip;", "\uff65\uff65\uff65"}, {"&rarr;", "\u2192"}, {"&larr;", "\u2190"}, {"&hArr;", "\u21d4"}, {"&rArr;", "\u21d2"}, {"&dagger;", "\u2020"}, {"&minus;", "-"}, {"&mdash;", "\u2015"}, {"\u2103&deg;C", "\u2103"}, {"</p><p><indent val=\"2\"><p>&nbsp;</p><p>", "</p><indent val=\"2\"><p><p>"}, {"<b>\uff3b\u7528\u4f8b\uff3d</b>", "\uff3b\u7528\u4f8b\uff3d"}};
    private static final String[][] REG_REPLACES = new String[][]{{"<p> +", "<p>"}};

    private static String getJPKey(String ykg) {
        Matcher m = YKG_BOLD.matcher(ykg);
        String key = "";
        while (m.find()) {
            key = String.valueOf(key) + m.group(1);
        }
        if (key.isEmpty()) {
            return ykg;
        }
        return "* " + key;
    }

    private static String fixJPKey(String line, String keyType) {
        Matcher m = DT_ID.matcher(line);
        String dt = m.find() ? m.group(2) : null;
        StringBuffer sb = new StringBuffer();
        m = YKG.matcher(line);
        int k = 0;
        TreeSet<String> set = new TreeSet<String>();
        while (m.find()) {
            if (k < m.start()) {
                sb.append(line.substring(k, m.start()));
            }
            String ykg = m.group(1);
            sb.append(ykg);
            String key = SedBodyHtml.getJPKey(ykg);
            if (!(key.isEmpty() || set.contains(key) || key.contains("<a "))) {
                set.add(key);
            }
            k = m.end();
        }
        if (k < line.length()) {
            sb.append(line.substring(k));
        }
        String line2 = sb.toString();
        if (set.isEmpty() || dt == null) {
            return line2;
        }
        k = line2.indexOf("<dd>");
        sb = new StringBuffer();
        if (k >= 0) {
            sb.append(line2.substring(0, k));
        }
        sb.append(LATKEY.makeKeys(dt, ZephyrUtil.makeKey(dt), keyType, set));
        nJPKey += set.size();
        if (k >= 0) {
            sb.append(line2.substring(k));
        } else {
            sb.append(line2);
        }
        return sb.toString();
    }

    private static String sed(String line, String keyType) {
        line = ZephyrUtil.sed(line, REPLACES, REG_REPLACES);
        line = SedBodyHtml.fixJPKey(line, keyType);
        return line;
    }

    private static void sed(String[] args) throws Exception {
        String line;
        InputStream in = System.in;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String keyType = args.length > 0 ? AppendLatinKeys.getKeyType(args[0]) : "\u8868\u8a18";
        while ((line = br.readLine()) != null) {
            if ((line = SedBodyHtml.sed(line, keyType)) == null) continue;
            System.out.println(line);
        }
        if (nJPKey > 0) {
            System.err.println("append " + nJPKey + " extra Japanese " + keyType + " keys");
        }
    }

    public static void main(String[] args) {
        ZephyrUtil.setUTF8Ouput();
        try {
            SedBodyHtml.sed(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

