/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.util.PDFIndex;
import zephyr.obunsha.util.RefEntry;
import zephyr.util.ZephyrUtil;

public class PetitPDFRef
extends PDFIndex {
    private final HashMap<String, RefEntry> vbnMap = new HashMap();
    private static final Pattern SNY = Pattern.compile("<span class=['\"]sny['\"]>(.+?)</span>");
    private static final Pattern VBN = Pattern.compile("<span class=['\"]vbn['\"]>(.+?)</span>");

    @Override
    public void handleLine(String prefix, RefEntry entry) {
        if (prefix.equals("appendice-") && entry.title.matches("[0-9]+.+")) {
            String vNum = entry.title.replaceAll("[^0-9]+", "");
            this.vbnMap.put(vNum, entry);
        }
    }

    private String handleSny(String dt, String dd) {
        Matcher m = SNY.matcher(dd);
        int idx = 0;
        StringBuilder sb = null;
        while (m.find()) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(dd.substring(idx, m.start()));
            sb.append(m.group());
            String s = m.group(1);
            for (RefEntry e : this.entryMap.values()) {
                if (e.title.length() < 2 || !s.contains(e.title) && !s.contains(e.key)) continue;
                String[] stringArray = e.jpgs;
                int n = e.jpgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String jpg = stringArray[n2];
                    sb.append("\u3000<jpgref id=\"");
                    sb.append(jpg);
                    sb.append("\"/>");
                    ++n2;
                }
            }
            idx = m.end();
        }
        if (sb == null) {
            return dd;
        }
        if (idx < dd.length()) {
            sb.append(dd.substring(idx));
        }
        return sb.toString();
    }

    private String handleVbn(String dt, String dd) {
        Matcher m = VBN.matcher(dd);
        int idx = 0;
        StringBuilder sb = null;
        while (m.find()) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(dd.substring(idx, m.start()));
            sb.append("<span class='vbn'>");
            String s = m.group(1);
            s = ZephyrUtil.zen2num(s);
            sb.append(s);
            RefEntry entry = this.vbnMap.get(s);
            if (entry != null) {
                String[] stringArray = entry.jpgs;
                int n = entry.jpgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String jpg = stringArray[n2];
                    sb.append(" <jpgref id=\"");
                    sb.append(jpg);
                    sb.append("\"/>");
                    ++n2;
                }
            } else {
                System.err.println(m.group());
            }
            sb.append("</span>");
            idx = m.end();
        }
        if (sb == null) {
            return dd;
        }
        if (idx < dd.length()) {
            sb.append(dd.substring(idx));
        }
        return sb.toString();
    }

    private String handleWordRef(String dt, String dd) {
        dd = dd.replaceAll("<a [^<>]*onClick=\"searchItem\\('([0-9]+)'[^\"]*\">(.+?)</a>", "<a href=\"#$1\">$2</a>");
        return dd;
    }

    String makeRef(String dt, String dd) {
        dd = this.handleSny(dt, dd);
        dd = this.handleVbn(dt, dd);
        dd = this.handleWordRef(dt, dd);
        return dd;
    }
}

