/*
 * Decompiled with CFR 0.152.
 */
package zephyr.ms.bookshelf2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class DumpHeadwords {
    private static final int START_OFFSET = 237493945;
    private int nEntry = 0;

    private void dumpHeader(byte[] buffer) throws UnsupportedEncodingException {
        int start;
        int i = start = 0;
        while (i < buffer.length - 16) {
            if (buffer[i] == 0) {
                if (i - start < 2) break;
                byte[] byteword = Arrays.copyOfRange(buffer, start, i);
                String word = new String(byteword, "Windows-31J");
                int data1 = (buffer[i + 2] & 0xFF) << 8 | buffer[i + 1] & 0xFF;
                int data2 = (buffer[i + 6] & 0xFF) << 24 | (buffer[i + 5] & 0xFF) << 16 | (buffer[i + 4] & 0xFF) << 8 | buffer[i + 3] & 0xFF;
                if (data1 > 0 && data1 <= 10) {
                    System.out.printf("%d\t%s\t%04X %08X\n", this.nEntry, word, data1, data2);
                    ++this.nEntry;
                }
                start = i += 7;
                if (i <= buffer.length && buffer[i] != 0) continue;
                break;
            }
            ++i;
        }
    }

    private void dump(String filename) throws Exception {
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedInputStream bin = new BufferedInputStream(in);
        byte[] buffer = new byte[2048];
        long nskip = bin.skip(237493945L);
        if (nskip != 237493945L) {
            bin.close();
            return;
        }
        int i = 0;
        while (i < 4890) {
            System.out.printf("page %d offset=0x%X\n", i, 237493945 + 2048 * i);
            int readlen = bin.read(buffer, 0, buffer.length);
            if (readlen != buffer.length) {
                System.err.println("readlen = " + readlen);
                break;
            }
            this.dumpHeader(buffer);
            ++i;
        }
        bin.close();
    }

    public static void main(String[] args) throws Exception {
        String file = args.length > 0 ? args[0] : "BS98JL.M20";
        DumpHeadwords app = new DumpHeadwords();
        app.dump(file);
    }
}

