/*
 * Decompiled with CFR 0.152.
 */
package zephyr.ms.bookshelf2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import zephyr.util.ZephyrUtil;

public class DumpBody {
    private static final int START_OFFSET = 65434644;
    private static final String M_KDJ = "\"m:kdj";
    private static final byte[] M_KDJ_BYTE = "\"m:kdj".getBytes();
    private int nEntry = 0;
    private byte[] lastBuffer = null;

    private int bfind(byte[] src, int offset, byte[] tgt) {
        int start = offset;
        while (start < src.length - tgt.length) {
            int i = 0;
            while (i < tgt.length) {
                if (src[start + i] != tgt[i]) break;
                ++i;
            }
            if (i == tgt.length) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private int byte2uint(byte b) {
        if (b >= 0) {
            return b;
        }
        return b & 0xFF;
    }

    private String data2char(byte[] data) {
        int d0 = this.byte2uint(data[0]);
        int d1 = this.byte2uint(data[1]);
        if ((129 <= d0 && d0 <= 159 || 224 <= d0 && d0 <= 239) && (64 <= d1 && d1 <= 126 || 128 <= d1 && d1 <= 252)) {
            return new String(data, ZephyrUtil.SHIFT_JIS);
        }
        return null;
    }

    private String getBody(byte[] buffer, int start) {
        StringBuilder sb = new StringBuilder();
        int idx = start;
        byte[] data = new byte[2];
        while (idx < buffer.length - 1) {
            data[0] = buffer[idx];
            data[1] = buffer[idx + 1];
            if (data[0] == 0 && data[1] == 0) break;
            String s = this.data2char(data);
            if (s != null) {
                sb.append(s);
                idx += 2;
                continue;
            }
            if (idx < buffer.length - 2) {
                data[1] = buffer[idx + 2];
                s = this.data2char(data);
                if (s != null) {
                    sb.append(s);
                    idx += 3;
                    continue;
                }
                ++idx;
                continue;
            }
            ++idx;
        }
        return sb.toString();
    }

    private void dumpBody(byte[] buffer) throws UnsupportedEncodingException {
        int idx = 0;
        int idx2 = 0;
        while (idx < buffer.length) {
            byte[] data;
            idx2 = this.bfind(buffer, idx, M_KDJ_BYTE);
            if (idx2 < 0) break;
            idx = idx2;
            while (idx >= 0) {
                if (buffer[idx] == 49) break;
                --idx;
            }
            if (idx < 0 && this.lastBuffer != null) {
                byte[] dataAfter = Arrays.copyOfRange(buffer, idx + 1, idx2);
                idx = this.lastBuffer.length - 1;
                while (idx >= 0) {
                    if (this.lastBuffer[idx] == 49) break;
                    --idx;
                }
                byte[] dataBefore = Arrays.copyOfRange(this.lastBuffer, idx + 1, this.lastBuffer.length);
                data = new byte[dataBefore.length + dataAfter.length];
                int i = 0;
                while (i < dataBefore.length) {
                    data[i] = dataBefore[i];
                    ++i;
                }
                i = 0;
                while (i < dataAfter.length) {
                    data[dataBefore.length + i] = dataAfter[i];
                    ++i;
                }
            } else {
                data = Arrays.copyOfRange(buffer, idx + 1, idx2 - 1);
            }
            String word = new String(data, "Windows-31J");
            byte[] data2 = Arrays.copyOfRange(buffer, idx2, idx2 + 17);
            String key = new String(data2, "Windows-31J");
            int bodyoff = 180;
            String body = idx2 + 180 + 10 < buffer.length ? this.getBody(buffer, idx2 + 180) : "??";
            System.out.printf("%d\t%s\t%s\t%s\n", this.nEntry, key, word, body);
            idx = idx2 + M_KDJ.length();
            ++this.nEntry;
        }
        this.lastBuffer = Arrays.copyOf(buffer, buffer.length);
    }

    private void dump(String filename) throws Exception {
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedInputStream bin = new BufferedInputStream(in);
        byte[] buffer = new byte[2048];
        long nskip = bin.skip(65434644L);
        if (nskip != 65434644L) {
            bin.close();
            return;
        }
        int i = 0;
        while (i < 1) {
            System.out.println("page " + i);
            int readlen = bin.read(buffer, 0, buffer.length);
            if (readlen == buffer.length) {
                this.dumpBody(buffer);
            } else {
                System.err.println("readlen = " + readlen);
            }
            ++i;
        }
        bin.close();
    }

    public static void main(String[] args) throws Exception {
        String file = args.length > 0 ? args[0] : "BS98JL.M20";
        DumpBody app = new DumpBody();
        app.dump(file);
    }
}

