/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.moraleboost.mecab.Lattice;
import net.moraleboost.mecab.Node;
import net.moraleboost.mecab.impl.StandardTagger;
import zephyr.kenkyusha.readers3.Lemmatizer;
import zephyr.util.MultiTreeMap;
import zephyr.util.ZephyrUtil;

public class MakeYoureiHtml {
    private StandardTagger tagger = null;
    private Lattice lattice = null;
    private final MultiTreeMap<String, Yourei> youreiMap = new MultiTreeMap(new IgnoreCaseComp());
    private static final Pattern DT = Pattern.compile("<dt[^>]*>(.+?)</dt>");
    private static final Pattern YOUREI = Pattern.compile("<p>\u3000- ([^\u3000]+)(\u3000(.+?))?</p>");
    private static final Pattern IDIOM = Pattern.compile("<p([^>]*)>(<idiom/>|<idiomjp/>)\u3000*(.+?)</p>");
    private final HashSet<String> keySet = new HashSet();
    private final LinkedList<String> keyList = new LinkedList();
    private final ArrayList<String> jpWordList = new ArrayList();
    private static final int YOUREI_MAX_ENTRY = 300;

    private void mecabInit() {
        this.mecabFini();
        this.tagger = new StandardTagger("");
        this.lattice = this.tagger.createLattice();
    }

    private void mecabFini() {
        if (this.lattice != null) {
            this.lattice.destroy();
            this.lattice = null;
        }
        if (this.tagger != null) {
            this.tagger.destroy();
            this.tagger = null;
        }
    }

    private String dropMarks(String txt) {
        StringBuilder sb = new StringBuilder();
        boolean inTag = false;
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            if (!inTag) {
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-' || c == ' ' || c == '\'') {
                    sb.append(c);
                } else if (c == '<') {
                    inTag = true;
                } else {
                    sb.append(" ");
                }
            } else if (inTag && c == '>') {
                inTag = false;
            }
            ++i;
        }
        return sb.toString().replaceAll(" +", " ").trim();
    }

    private void putYourei(String dt, String en, String jp) {
        this.keySet.clear();
        String en2 = this.dropMarks(en);
        String[] words = en2.split(" +");
        ArrayList<LinkedList<String>> lemmaWords = new ArrayList<LinkedList<String>>(words.length);
        int i = 0;
        while (i < words.length) {
            lemmaWords.add(Lemmatizer.lemma(words[i]));
            ++i;
        }
        Yourei yourei = new Yourei(dt, en, jp);
        int i2 = 0;
        while (i2 < words.length) {
            this.keyList.clear();
            for (String key0 : (LinkedList)lemmaWords.get(i2)) {
                if (i2 < words.length - 2 && (words[i2 + 1].equals("a") || words[i2 + 1].equals("an") || words[i2 + 1].equals("the"))) {
                    for (String key2 : (LinkedList)lemmaWords.get(i2 + 2)) {
                        this.keyList.add(String.valueOf(key0) + " " + key2);
                    }
                    continue;
                }
                if (i2 < words.length - 1) {
                    for (String key1 : (LinkedList)lemmaWords.get(i2 + 1)) {
                        this.keyList.add(String.valueOf(key0) + " " + key1);
                    }
                    continue;
                }
                this.keyList.add(key0);
            }
            for (String key : this.keyList) {
                if (this.keySet.contains(key)) continue;
                this.youreiMap.put(key, yourei);
                this.keySet.add(key);
            }
            ++i2;
        }
        if (jp != null) {
            this.jpWordList.clear();
            this.lattice.setSentence(ZephyrUtil.hex2uni(jp));
            this.tagger.parse(this.lattice);
            Node node = this.lattice.bosNode();
            while (node != null) {
                String surface = node.surface();
                String feature = node.feature();
                if (!(surface.isEmpty() || surface.charAt(0) < '\u0100' || surface.contains("<") || surface.contains(">"))) {
                    if (feature.startsWith("\u8a18\u53f7,") && !surface.equals("\u3002")) {
                        surface.equals("\u3001");
                    }
                    this.jpWordList.add(surface);
                }
                node = node.next();
            }
            i = 0;
            while (i < this.jpWordList.size()) {
                String key;
                key = this.jpWordList.get(i);
                if (i < this.jpWordList.size() - 1) {
                    key = String.valueOf(key) + this.jpWordList.get(i + 1);
                }
                if (!this.keySet.contains(key)) {
                    this.youreiMap.put(key, yourei);
                    this.keySet.add(key);
                }
                ++i;
            }
        }
    }

    private void outputYourei() {
        MultiTreeMap<String, Yourei> map = this.youreiMap;
        String dtPre = "<dt title=\"\u25a0 ";
        for (String key : map.keySet()) {
            LinkedList list = map.getList(key);
            System.out.println(String.valueOf(dtPre) + key + " " + list.size() + "\">\u25a0 " + key + "</dt><dd>" + list.size());
            int n = 0;
            for (Yourei yourei : list) {
                String en = yourei.en.replace("href=\"#", "href=\"body.html#");
                if (yourei.jp != null) {
                    String jp = yourei.jp.replace("href=\"#", "href=\"body.html#");
                    System.out.println("<p>[" + yourei.lemma + "] " + en + "\u3000" + jp + "</p>");
                } else {
                    System.out.println("<p>[" + yourei.lemma + "] " + en + "</p>");
                }
                if (++n < 300) continue;
                System.out.println("....");
                System.err.println(String.valueOf(key) + "\t" + list.size());
                break;
            }
            System.out.println("</dd>");
        }
    }

    private void output() {
        System.out.println("<html><body>");
        this.outputYourei();
        System.out.println("</body></html>");
    }

    private void parse(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        String dt = "";
        String idiomEn = null;
        String idiomJp = null;
        int nDt = 0;
        int nYourei = 0;
        int nIdiom = 0;
        while ((line = br.readLine()) != null) {
            Matcher m = DT.matcher(line);
            if (m.find()) {
                if (idiomEn != null) {
                    this.putYourei(dt, idiomEn, idiomJp);
                    ++nIdiom;
                    idiomJp = null;
                    idiomEn = null;
                }
                dt = m.group(1);
                dt = dt.replaceAll("&#xb7;", "");
                dt = ZephyrUtil.dropMarks(ZephyrUtil.hex2uni(dt));
                ++nDt;
                continue;
            }
            m = YOUREI.matcher(line);
            if (m.find()) {
                if (idiomEn != null) {
                    this.putYourei(dt, idiomEn, idiomJp);
                    ++nIdiom;
                    idiomJp = null;
                    idiomEn = null;
                }
                String en = m.group(1);
                String jp = m.group(3);
                this.putYourei(dt, en, jp);
                ++nYourei;
                continue;
            }
            m = IDIOM.matcher(line);
            if (m.find()) {
                String tag = m.group(2);
                if (tag.equals("<idiom/>")) {
                    if (idiomEn != null) {
                        this.putYourei(dt, idiomEn, idiomJp);
                        ++nIdiom;
                    }
                    idiomEn = m.group(3);
                    idiomJp = null;
                    continue;
                }
                if (idiomEn == null) continue;
                if (idiomJp == null) {
                    idiomJp = m.group(3);
                    continue;
                }
                idiomJp = String.valueOf(idiomJp) + "<br>" + m.group(3);
                continue;
            }
            if (idiomEn == null) continue;
            if (line.startsWith("<p>\u3000") && line.endsWith("</p>")) {
                String jppart = line.substring(3, line.length() - 4);
                if (idiomJp == null) {
                    idiomJp = jppart;
                    continue;
                }
                idiomJp = String.valueOf(idiomJp) + "<br>" + jppart;
                continue;
            }
            this.putYourei(dt, idiomEn, idiomJp);
            ++nIdiom;
            idiomJp = null;
            idiomEn = null;
        }
        if (idiomEn != null) {
            this.putYourei(dt, idiomEn, idiomJp);
            ++nIdiom;
            idiomJp = null;
            idiomEn = null;
        }
        br.close();
        System.err.println(String.valueOf(nDt) + " \u4e3b\u898b\u51fa\u3057");
        System.err.println(String.valueOf(nYourei) + " \u7528\u4f8b");
        System.err.println(String.valueOf(nIdiom) + " \u6210\u53e5");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeYoureiHtml app = new MakeYoureiHtml();
            try {
                try {
                    app.mecabInit();
                    app.parse(args[0]);
                    app.output();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    app.mecabFini();
                }
            }
            finally {
                app.mecabFini();
            }
        } else {
            System.err.println("Usage: java MakeYoureiHtml body.html");
        }
    }

    private class IgnoreCaseComp
    implements Comparator<String> {
        private IgnoreCaseComp() {
        }

        @Override
        public int compare(String o1, String o2) {
            int r = o1.compareToIgnoreCase(o2);
            if (r != 0) {
                return r;
            }
            return o1.compareTo(o2);
        }
    }

    static class Yourei {
        final String lemma;
        final String en;
        final String jp;

        Yourei(String lemma, String en, String jp) {
            this.lemma = lemma;
            this.en = en;
            this.jp = jp;
        }
    }
}

