/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MakeFullPlist {
    private static final Pattern PLIST = Pattern.compile("<key>[hz]([a-z0-9]+)</key><string>(.*?)</string>");
    private final HashMap<String, String> gaijiMap = new HashMap();

    private void loadPlist(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Matcher m = PLIST.matcher(line);
            if (!m.find()) continue;
            this.gaijiMap.put(m.group(1), m.group(2));
        }
        br.close();
    }

    private int nextEBCode(int ebCode) {
        if ((ebCode & 0xFF) >= 126) {
            ebCode &= 0xFFFFFF00;
            ebCode += 289;
        } else {
            ++ebCode;
        }
        return ebCode;
    }

    private void output(String zh, int start, int end) {
        int code = start;
        while (code <= end) {
            String codeStr = String.format("%x", code);
            String str = this.gaijiMap.get(codeStr);
            if (str == null) {
                str = " ";
            }
            System.out.printf("<key>%s%s</key><string>%s</string>\n", zh, codeStr, str);
            code = this.nextEBCode(code);
        }
    }

    private void output() {
        this.output("h", 41249, 43302);
        this.output("z", 45380, 47417);
    }

    public static void main(String[] args) throws Exception {
        MakeFullPlist app = new MakeFullPlist();
        String filename = args.length > 0 ? args[0] : "READERS3.plist";
        app.loadPlist(filename);
        app.output();
    }
}

