/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kenkyusha.readers3.ExtraKeys;
import zephyr.kenkyusha.readers3.R3Gaiji;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private final R3Gaiji gaiji;
    private final ExtraKeys extraKeys;
    private static final String RET;
    private static final HashMap<String, String> eb2htmlMap;
    private static final String EP_DT_START = "<1F09><0001><1F41><0160>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private String dtId = "";
    private final HashSet<String> posSet = new HashSet();
    public static final String SUBKEY = "<subkey/>";
    public static final String JP = "";
    public static final String EXMP_EN = "<exmp/>";
    public static final String EXMP_JP = "<exmpjp/>";
    public static final String IDIOM_EN = "<idiom/>";
    public static final String IDIOM_JP = "<idiomjp/>";
    private int nExample = 0;
    private int nIdiom = 0;
    private static final Pattern EP_REF;
    private static final Pattern SMCE_S;
    private static final Pattern SUBSECTION;
    private static final String DD_START = "<dd>";
    private int nEnPostKey = 0;
    private static final Pattern EN_POST;
    private final LinkedList<String> invalidEnKeys = new LinkedList();
    private int nJpKey = 0;
    private static final Pattern JP_PART;
    private static final Pattern DT_DD;

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        String zenzen = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        int i = 0;
        while (i < zenzen.length()) {
            char c = zenzen.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
            ++i;
        }
        RET = System.getProperty("line.separator");
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
        SMCE_S = Pattern.compile("\uff33\uff2d\uff23\uff1a\uff25([^\\[\\]]+?)\uff33\uff2d\uff23\uff1a\uff33");
        SUBSECTION = Pattern.compile("<p>(\u25ba(<i>[^<]+?</i>(, <i>[^<]+?</i>)*))");
        EN_POST = Pattern.compile("<subkey/>(.+)</p>");
        JP_PART = Pattern.compile("(.+?)</p>");
        DT_DD = Pattern.compile("(<dt[^>]*>(.+?)</dt>)");
    }

    MakeBodyHtml() throws Exception {
        this.gaiji = new R3Gaiji("GaijiMap.xml");
        this.extraKeys = new ExtraKeys("extrakeys.txt");
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character han = zenhanMap.get(Character.valueOf(c));
        if (han != null) {
            return han.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return '#';
    }

    private String ep2html(String line, HashSet<String> refs) {
        String brRetP;
        StringBuilder sb = new StringBuilder();
        boolean bZenkaku = true;
        int i = line.indexOf(93);
        String[] v = line.substring(1, i).replace(" ", "0").split(":");
        if (v[1].equals("800")) {
            v[0] = String.format("%X", Integer.parseInt(v[0], 16) + 1);
            v[1] = "000";
        }
        String pos = String.valueOf(v[0]) + v[1];
        boolean isRefered = refs.contains(pos);
        String linebody = line.substring(++i);
        if (!isRefered && linebody.startsWith(EP_ANKER)) {
            return JP;
        }
        boolean inDT = false;
        if (isRefered) {
            brRetP = "</p>" + RET + "<p id=\"" + pos + "\">";
            this.posSet.add(pos);
        } else {
            brRetP = "</p>" + RET + "<p>";
        }
        while (i < line.length()) {
            char c;
            block154: {
                String code;
                c = line.charAt(i);
                if (c != '<') break block154;
                switch (code = line.substring(i + 1, i + 5)) {
                    case "1FE0": {
                        String code2;
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0001": {
                                sb.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (inDT) break;
                                sb.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String code2;
                        String codeX = line.substring(i);
                        if (codeX.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + pos);
                            }
                            if (isRefered) {
                                sb.append("<dt id=\"" + pos + "\">");
                                isRefered = false;
                            } else {
                                sb.append("<dt>");
                            }
                            this.dtId = pos;
                            inDT = true;
                            i += EP_DT_START.length();
                            break;
                        }
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0003": {
                                sb.append(String.valueOf(brRetP));
                                break;
                            }
                            case "0004": {
                                sb.append(String.valueOf(brRetP));
                                break;
                            }
                            case "0005": {
                                sb.append(String.valueOf(brRetP) + "\u3000");
                                break;
                            }
                            case "0020": {
                                sb.append(String.valueOf(brRetP));
                                break;
                            }
                            case "0024": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0030": {
                                sb.append(String.valueOf(brRetP));
                                break;
                            }
                            case "0103": {
                                sb.append(String.valueOf(brRetP));
                                break;
                            }
                            case "0101": {
                                sb.append(String.valueOf(brRetP) + SUBKEY);
                                break;
                            }
                            case "0104": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0008": 
                            case "0028": 
                            case "0038": {
                                sb.append(String.valueOf(brRetP) + "\u3000- " + EXMP_EN);
                                ++this.nExample;
                                break;
                            }
                            case "0009": 
                            case "0029": 
                            case "0039": {
                                sb.append("\u3000<exmpjp/>");
                                break;
                            }
                            case "0106": {
                                sb.append(String.valueOf(brRetP) + IDIOM_EN);
                                ++this.nIdiom;
                                break;
                            }
                            case "0107": {
                                sb.append(String.valueOf(brRetP) + "\u3000" + IDIOM_JP);
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + code2);
                            }
                            case "0002": 
                            case "0010": 
                            case "0013": 
                            case "0014": 
                            case "0015": 
                            case "0018": 
                            case "0019": 
                            case "0023": 
                            case "0025": 
                            case "0033": 
                            case "0034": 
                            case "0035": 
                            case "0040": 
                            case "0100": 
                            case "0105": 
                            case "0109": 
                            case "0113": 
                            case "0115": 
                            case "0117": 
                            case "0119": 
                            case "0120": 
                            case "0127": 
                            case "0129": 
                            case "9999": 
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        if (inDT) {
                            sb.append("</dt><dd><p>");
                            inDT = false;
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bZenkaku = false;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bZenkaku = true;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String closeTag : this.closeTags) {
                            sb.append(closeTag);
                        }
                        this.closeTags.clear();
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        sb.append("\u3000\u97f3\u58f0");
                        i += 3 * EPTAG_LEN;
                        i = line.indexOf(93, i);
                        i = line.indexOf(93, i + 1) + 1;
                        break;
                    }
                    default: {
                        if (code.compareTo("A121") >= 0 && code.compareTo("FE7E") <= 0) {
                            sb.append(this.gaiji.gaiji(code));
                        } else {
                            String tag = eb2htmlMap.get(code);
                            if (tag != null) {
                                sb.append(tag);
                            }
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bZenkaku) {
                sb.append(c);
            } else {
                sb.append(MakeBodyHtml.zen2han(c));
            }
            ++i;
        }
        String l = sb.toString();
        if (inDT) {
            l = String.valueOf(l) + "</dt><dd><p>";
        }
        return l;
    }

    private HashSet<String> findRefs(String filename) throws Exception {
        String line;
        HashSet<String> refs = new HashSet<String>();
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        while ((line = br.readLine()) != null) {
            Matcher m = EP_REF.matcher(line);
            while (m.find()) {
                refs.add(String.valueOf(m.group(1)) + m.group(2));
            }
        }
        br.close();
        System.err.println("found " + refs.size() + " unique refs");
        return refs;
    }

    private String fixSMCES(String dd) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        Matcher m = SMCE_S.matcher(dd);
        while (m.find()) {
            if (idx < m.start()) {
                sb.append(dd.substring(idx, m.start()));
            }
            sb.append(m.group(1).toUpperCase());
            idx = m.end();
        }
        if (idx < dd.length()) {
            sb.append(dd.substring(idx));
        }
        return sb.toString();
    }

    private String normalize(String dd) {
        dd = dd.replaceAll("(<p[^>]*>)[\u3000 ]*(\\(<b>[0-9]+</b>\\))", "$1\u3000$2");
        dd = dd.replace("\u25ba", "</p><p>\u25ba");
        dd = dd.replaceAll("([^ \u3000])\u25c6", "$1\u3000\u25c6");
        dd = dd.replaceAll("(<p[^>]*>\u3000*<i>[a-z]+</i>(, *<i>[a-z]+</i>)*) *", "$1\u3000");
        dd = this.fixSMCES(dd);
        dd = dd.replaceAll("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]", "<a href=\"#$2$3\">$1</a>");
        dd = dd.replaceAll("[\u3000 ]+</p>", "</p>");
        dd = dd.replaceAll("<p[^>]*></p>", JP);
        if ((dd = dd.replace("<p><jp/></p><p>", "<p><jp/>")).length() > 1000) {
            int brIdx = 0;
            Matcher m = SUBSECTION.matcher(dd);
            StringBuilder dd2 = null;
            StringBuilder subToc = null;
            int idx = 0;
            int subIdx = 0;
            while (m.find()) {
                if (subToc == null) {
                    dd2 = new StringBuilder();
                    subToc = new StringBuilder();
                }
                if (idx < m.start()) {
                    dd2.append(dd.substring(idx, m.start()));
                }
                String subId = String.valueOf(this.dtId) + "." + ++subIdx;
                if (dd2.length() - brIdx > 50) {
                    dd2.append("<br><br>");
                    brIdx = dd2.length();
                }
                dd2.append("<p id=\"");
                dd2.append(subId);
                dd2.append("\">");
                dd2.append(m.group(1));
                if (subIdx >= 2) {
                    subToc.append("\u3000");
                }
                subToc.append("\u2192<a href=\"#");
                subToc.append(subId);
                subToc.append("\">");
                subToc.append(m.group(2));
                subToc.append("</a>");
                idx = m.end();
            }
            if (dd2 != null && subIdx >= 2) {
                if (idx < dd.length()) {
                    dd2.append(dd.substring(idx));
                }
                dd = dd2.toString();
                idx = dd.indexOf(DD_START) + DD_START.length();
                dd = String.valueOf(dd.substring(0, idx)) + "<p>" + subToc.toString().trim() + "</p>" + RET + dd.substring(idx).trim();
            }
        }
        return dd;
    }

    private String makeKeyList(String dt, Collection<String> keys) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append("<key title=\"");
            sb.append(key);
            sb.append(" \uff1c");
            sb.append(dt);
            sb.append("\uff1e\">");
            sb.append(key);
            sb.append("</key>");
        }
        return sb.toString();
    }

    private String makeEnKeys(String dt, String dd) {
        Matcher m = EN_POST.matcher(dd);
        LinkedList<String> keys = null;
        String dt2 = null;
        while (m.find()) {
            if (keys == null) {
                keys = new LinkedList<String>();
                dt2 = dt.replaceAll("<sup>.+?</sup>", JP);
                dt2 = dt2.replaceAll("\u300a.+?\u300b", JP);
            }
            String line = m.group(1);
            int k = (line = line.replace("-<b>", "-").replace("<b>", JP)).lastIndexOf("</b>");
            if (k > 0) {
                line = line.substring(0, k);
            }
            line = line.replace("</b>", JP);
            line = line.replaceAll("<a[^>]*>", JP).replace("</a>", JP);
            String[] stringArray = line.split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.startsWith("-")) {
                    word = word.substring(1);
                    int idx = dt2.lastIndexOf(183);
                    if (idx < 0) {
                        idx = dt2.lastIndexOf(45);
                    }
                    if (idx < 0) {
                        if (dt2.endsWith("y") && word.startsWith("i\u00b7n")) {
                            keys.add(String.valueOf(dt2.substring(0, dt2.length() - 1)) + word);
                        } else if (dt2.endsWith("ism") && word.endsWith("ist")) {
                            keys.add(String.valueOf(dt2.substring(0, dt2.length() - 3)) + word);
                        } else {
                            String[] exKeys = this.extraKeys.keys(dt2, word);
                            if (exKeys != null) {
                                String[] stringArray2 = exKeys;
                                int n3 = exKeys.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String ek = stringArray2[n4];
                                    keys.add(ek);
                                    ++n4;
                                }
                            } else {
                                this.invalidEnKeys.add(String.valueOf(dt2) + "###" + word);
                            }
                        }
                    } else {
                        keys.add(String.valueOf(dt2.substring(0, idx)) + word);
                    }
                } else if (word.startsWith("\uff5e") && word.length() > 1) {
                    keys.add(String.valueOf(dt2) + word.substring(1));
                } else if (!word.contains("\uff5e")) {
                    keys.add(word);
                }
                ++n2;
            }
        }
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        this.nEnPostKey += keys.size();
        return this.makeKeyList(dt, keys);
    }

    private String makeJpKeys(String dt, String dd) {
        TreeSet<String> set = new TreeSet<String>();
        Matcher m = JP_PART.matcher(dd);
        while (m.find()) {
            String jpPart = m.group(1);
            jpPart = jpPart.replaceAll("[\u300a\u3018].[\u300b\u3019]", JP);
            jpPart = jpPart.replaceAll("\u2605.+", JP);
            jpPart = jpPart.replaceAll("<a[^>]+>", JP).replaceAll("</a>", JP);
            jpPart = jpPart.replaceAll("<[ib]>.+?</[ib]>", JP);
            String[] stringArray = jpPart.split("[\ue240 \u00b7\\.,;\\[\\]\\(\\)\u3008\u3009\u300a\u300b\u3018\u3019\u2026]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.length() > 0) {
                    set.add(word);
                }
                ++n2;
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        this.nJpKey += set.size();
        return this.makeKeyList(dt, set);
    }

    private String makeJpKeys(String dtdd) {
        String dd;
        Matcher m = DT_DD.matcher(dtdd);
        if (!m.find()) {
            return dtdd;
        }
        String dt = m.group(2);
        String enKeys = this.makeEnKeys(dt, dd = dtdd.substring(m.end()));
        if (enKeys == null) {
            return dtdd;
        }
        return String.valueOf(m.group(1)) + enKeys + dd;
    }

    private void parse(String filename) throws Exception {
        String line;
        HashSet<String> refs = this.findRefs(filename);
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        StringBuilder sb = null;
        System.out.println("<html><body>");
        int nEntry = 0;
        while ((line = br.readLine()) != null) {
            String html;
            if ((line = line.trim()).isEmpty() || (html = this.ep2html(line, refs)).isEmpty()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else if (html.startsWith("<dt") && sb != null) {
                String out = this.makeJpKeys(String.valueOf(this.normalize(sb.toString())) + "</p></dd>");
                System.out.println(out);
                sb = new StringBuilder();
                if (++nEntry % 1000 == 0) {
                    if (nEntry % 10000 == 0) {
                        System.err.print(nEntry / 10000);
                    } else {
                        System.err.print(".");
                    }
                }
            }
            sb.append(html);
        }
        br.close();
        if (sb != null) {
            System.out.println(String.valueOf(this.normalize(sb.toString())) + "</p></dd>");
        }
        System.out.println("</body></html>");
        System.err.println();
        if (!unknownHanSet.isEmpty()) {
            System.err.println("WARN: Unknown Hankaku characters");
            System.err.println(unknownHanSet.toString());
        }
        TreeSet<String> unknownPosSet = new TreeSet<String>();
        for (String refPos : refs) {
            if (this.posSet.contains(refPos)) continue;
            unknownPosSet.add(refPos);
        }
        if (!unknownPosSet.isEmpty()) {
            System.err.println("WARN: Unknown Pos: " + unknownPosSet.size());
            System.err.println(unknownPosSet.toString());
        }
        System.err.println(String.valueOf(nEntry) + " entries");
        System.err.println("append " + this.nEnPostKey + " English extra keys");
        System.err.println(String.valueOf(this.nIdiom) + " idioms, " + this.nExample + " example sentenses");
        if (!this.invalidEnKeys.isEmpty()) {
            for (String l : this.invalidEnKeys) {
                System.err.println(l);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml app = new MakeBodyHtml();
            try {
                app.parse(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/readers3.txt");
        }
    }
}

