/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo2;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class Util2 {
    private static final Pattern EN_KEY = Pattern.compile("\\(= *(.+?)\\)");
    public static final String KATUYOU_DELIM_REGEX = "\uff0c *";
    public static final String KATUYOU_DELIM = "\uff0c";

    public static ArrayList<String> splitTab(String line, int minSize) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '\t') {
                list.add(line.substring(start, i));
                start = i + 1;
            }
            ++i;
        }
        if (start < line.length()) {
            list.add(line.substring(start));
        }
        while (list.size() < minSize) {
            list.add("");
        }
        return list;
    }

    public static String dropDot(String line) {
        return line.replace("\uff65", "");
    }

    public static String makeENKeys(String en) {
        Matcher m = EN_KEY.matcher(en);
        StringBuilder sb = null;
        while (m.find()) {
            String key;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if ((key = m.group(1)).length() == 0) continue;
            sb.append("<key type=\"\u8868\u8a18\">");
            sb.append(key);
            sb.append("</key>");
        }
        String enDrop = en.replaceAll("\\[.{1,2}?\\]", "");
        if (!enDrop.equals(en)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("<key type=\"\u8868\u8a18\">");
            sb.append(enDrop);
            sb.append("</key>");
        }
        if (sb == null) {
            return "";
        }
        return sb.toString();
    }

    public static String makeKeys(String dd, String dt) {
        String[] v = dd.split("[\uff0c\uff1b\uff1d\u3008\u3009\u3014\u3015\uff08\uff09=]+");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if ((key = key.trim()).length() != 0) {
                if (key.contains("<SUB>")) {
                    Util2.appendKey(sb, key, dt);
                } else {
                    String[] stringArray2 = key.split("[\u30fb\\(\\)]+");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String subKey = stringArray2[n4];
                        Util2.appendKey(sb, subKey, dt);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static void appendKey(StringBuilder sb, String showKey, String dt) {
        Util2.appendKey(sb, null, showKey, dt);
    }

    public static void appendKey(StringBuilder sb, String preMark, String showKey, String dt) {
        String key;
        if (ZephyrUtil.isKatakana(showKey)) {
            sb.append("<key type=\"\u304b\u306a\" title=\"");
            key = ZephyrUtil.katakana2hiragana(showKey);
        } else {
            sb.append("<key type=\"\u8868\u8a18\" title=\"");
            key = showKey;
        }
        if (key.contains("<SUB>") && key.matches("[A-Z0-9</>\uff0d\\-\\(\\)]+")) {
            key = key.replace("<SUB>", "");
            key = key.replace("</SUB>", "");
            key = key.replaceAll("[\\(\\)\\-\uff0d]", "");
        }
        if (preMark != null) {
            sb.append(preMark);
        }
        showKey = showKey.trim();
        dt = dt.trim();
        key = key.trim();
        sb.append(showKey);
        sb.append(" - ");
        sb.append(dt);
        sb.append("\">");
        sb.append(key);
        sb.append("</key>");
    }

    public static void numbering(StringBuilder sb, String[] v) {
        if (v.length == 1) {
            sb.append(v[0]);
            return;
        }
        int i = 1;
        String[] stringArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            w = w.trim();
            if (i > 1) {
                sb.append(KATUYOU_DELIM);
            }
            sb.append(i);
            sb.append(". ");
            sb.append(w);
            ++i;
            ++n2;
        }
    }
}

