/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import zephyr.kagakudoujin.kagakueigo.Gaiji;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.kagakudoujin.kagakueigo2.Util2;
import zephyr.util.ZephyrUtil;

public class MakeRyakugoHtml {
    private boolean showGif = false;
    private boolean showMol = false;
    private int nEntry = 0;

    MakeRyakugoHtml(String[] args) {
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("gif")) {
                this.showGif = true;
            } else if (arg.equals("mol")) {
                this.showMol = true;
            }
            ++i;
        }
    }

    private void out(String dt, String en, String rep, String gif, String mol) {
        if (dt.isEmpty() || en.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<dt>*");
        sb.append(dt);
        sb.append("</dt>");
        sb.append("<dd>");
        if (!en.isEmpty()) {
            sb.append("<p>");
            sb.append(en);
            sb.append("</p>");
        }
        if (this.showGif && !gif.isEmpty() && !gif.startsWith("dum")) {
            sb.append("<p><img src=\"jpg/");
            sb.append(gif);
            sb.append(".jpg\"/></p>");
        }
        if (this.showMol && !mol.isEmpty() && !mol.startsWith("dum")) {
            sb.append("<p><img src=\"moljpg/");
            sb.append(mol);
            sb.append(".mol0.jpg\"/> <img src=\"moljpg/");
            sb.append(mol);
            sb.append(".mol1.jpg\"/></p>");
        }
        sb.append("</dd>");
        String txt = sb.toString();
        txt = txt.replace("<I>N</N>,<I>N</I>", "<I>N</I>,<I>N</I>");
        txt = Util.normalize(txt);
        txt = Gaiji.convert(txt);
        System.out.println(txt);
    }

    private void load(File file) throws Exception {
        String line;
        System.err.print(String.valueOf(file.getName()) + " ");
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        System.out.println("<html><body>");
        while ((line = br.readLine()) != null) {
            ArrayList<String> list = Util2.splitTab(line, 6);
            String dt = list.get(1);
            String en = list.get(2);
            String rep = list.get(3);
            String mol = list.get(4);
            String gif = list.get(5);
            this.out(dt, en, rep, gif, mol);
            ++this.nEntry;
        }
        br.close();
        System.out.println("</body></html>");
        System.err.println();
        System.err.println(String.valueOf(this.nEntry) + "\u9805\u76ee");
    }

    public static void main(String[] args) throws Exception {
        String filename = args.length > 0 ? args[0] : "C:\\Program Files\\Kagaku-Dojin\\\u5316\u5b66\u82f1\u8a9e\u306e\u6d3b\u7528\u8f9e\u5178Ver.2\\mst\\txt\\RYAKUGO.txt";
        File file = new File(filename);
        if (!file.exists()) {
            System.err.println(String.valueOf(filename) + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (!file.canRead()) {
            System.err.println(String.valueOf(filename) + " \u306f\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
            return;
        }
        System.err.println(String.valueOf(file.getAbsolutePath()) + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        MakeRyakugoHtml app = new MakeRyakugoHtml(args);
        app.load(file);
    }
}

