/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import zephyr.kagakudoujin.kagakueigo.Gaiji;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.kagakudoujin.kagakueigo2.Util2;
import zephyr.util.ZephyrUtil;

public class MakeEJHtml {
    private boolean makeJPkey = false;
    private boolean withWav = false;
    private static final String IRREGULARS_TXT = "\u7146\u9239\u70bb";
    private static HashSet<Character> IRREGULARS = new HashSet();
    private int nEntry = 0;

    static {
        int i = 0;
        while (i < IRREGULARS_TXT.length()) {
            IRREGULARS.add(Character.valueOf(IRREGULARS_TXT.charAt(i)));
            ++i;
        }
    }

    MakeEJHtml(String[] args) {
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("jpenkey")) {
                this.makeJPkey = true;
            } else if (arg.equals("wav")) {
                this.withWav = true;
            }
            ++i;
        }
    }

    private void out(String en, String jp, String wav) {
        StringBuilder sb = new StringBuilder();
        String enNoDot = Util2.dropDot(en);
        sb.append("<dt title=\"");
        sb.append(enNoDot);
        sb.append("\">");
        sb.append(en);
        sb.append("</dt>");
        sb.append(Util2.makeENKeys(enNoDot));
        if (this.makeJPkey) {
            sb.append(Util2.makeKeys(jp, enNoDot));
        }
        sb.append("<dd>");
        if (this.withWav && wav.length() > 0) {
            sb.append("<a href=\"wav/");
            sb.append(wav);
            sb.append(".WAV\">\u767a\u97f3</a>");
        }
        sb.append("<p>");
        sb.append(jp);
        sb.append("</p></dd>");
        String txt = sb.toString();
        txt = Util.normalize(txt);
        txt = Gaiji.convert(txt);
        System.out.println(txt);
    }

    private String fixJp(String en, String jp) {
        if (en.equals("heme i\uff65ron")) {
            jp = jp.replace("\u0013", "");
        }
        boolean hasIrregular = false;
        int i = 0;
        while (i < jp.length()) {
            char c = jp.charAt(i);
            if (IRREGULARS.contains(Character.valueOf(c))) {
                hasIrregular = true;
            }
            if (c < ' ') {
                System.err.println();
                System.err.printf("\uff0a\u7570\u5e38\u6587\u5b57\uff1a '%c'=0x%x\n", Character.valueOf(c), (int)c);
                System.err.println(String.valueOf(en) + "\t" + jp);
            }
            ++i;
        }
        if (hasIrregular) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < jp.length()) {
                char c = jp.charAt(i2);
                if (IRREGULARS.contains(Character.valueOf(c))) {
                    sb.append(String.format("&#x%x;", c));
                } else {
                    sb.append(c);
                }
                ++i2;
            }
            return sb.toString();
        }
        return jp;
    }

    private void loadEIWAFile(File file) throws Exception {
        String line;
        System.err.print(String.valueOf(file.getName()) + " ");
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        while ((line = br.readLine()) != null) {
            ArrayList<String> list = Util2.splitTab(line, 6);
            String en = list.get(3);
            String jp = list.get(4);
            String wav = list.get(5);
            jp = this.fixJp(en, jp);
            this.out(en, jp, wav);
            ++this.nEntry;
        }
        br.close();
    }

    private void loadEIWA(File dir) throws Exception {
        Object[] files = dir.list();
        Arrays.sort(files);
        System.out.println("<html><body>");
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            String l = ((String)file).toLowerCase();
            if (l.startsWith("eiwa_") && ((String)file).endsWith(".txt")) {
                this.loadEIWAFile(new File(dir, (String)file));
            }
            ++n2;
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println(String.valueOf(this.nEntry) + "\u9805\u76ee");
    }

    public static void main(String[] args) throws Exception {
        String txtDir = args.length > 0 ? args[0] : "C:\\Program Files\\Kagaku-Dojin\\\u5316\u5b66\u82f1\u8a9e\u306e\u6d3b\u7528\u8f9e\u5178Ver.2\\mst\\txt";
        File dir = new File(txtDir);
        if (!dir.exists()) {
            System.err.println(String.valueOf(txtDir) + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (!dir.isDirectory()) {
            System.err.println(String.valueOf(txtDir) + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        System.err.println(String.valueOf(dir.getAbsolutePath()) + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        MakeEJHtml app = new MakeEJHtml(args);
        app.loadEIWA(dir);
    }
}

