/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kagakudoujin.kagakueigo.Gaiji;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.kagakudoujin.kagakueigo2.Util2;
import zephyr.util.ZephyrUtil;

public class KatuyouWriter {
    private final int version;
    private boolean katuyouEnKey = false;
    private boolean katuyouJpKey = false;
    private boolean katuKey;
    private static int nextId = 0;
    private final HashMap<String, Integer> jp2idMap = new HashMap();
    private final LinkedList<KEntry> entries = new LinkedList();
    private static final Pattern PART_HEAD = Pattern.compile("\u3000?(\u3014.+?\u3015) *");
    private static final HashMap<String, String> jprelMap = new HashMap();

    static {
        jprelMap.put("\u2026\u306b\u3064\u304d", "\u306b\u3064\u304d");
        jprelMap.put("\u5171\u540c", "\u5171\u540c\uff08\u5354\u540c\uff09");
        jprelMap.put("\u57fa\u6e96", "\u57fa\u6e96\uff08\u898f\u6e96\uff09");
        jprelMap.put("\u4e3b(\u304a\u3082)\u306b", "\u4e3b\u306b");
        jprelMap.put("\u4e3b(\u304a\u3082)\u306a", "\u4e3b\u306b");
        jprelMap.put("\u96f6(\u308c\u3044)", "\u96f6");
        jprelMap.put("\u753b\u5206", "\u753b\u5206\uff08\u30d5\u30e9\u30af\u30b7\u30e7\u30f3\uff09");
        jprelMap.put("\u6eb6\u51fa\u3000", "\u6eb6\u51fa");
        jprelMap.put("\u79fb\u52d5\u5ea6", "\u79fb\uff08\u6613\uff09\u52d5\u5ea6");
        jprelMap.put("\u6613\u52d5\u5ea6", "\u79fb\uff08\u6613\uff09\u52d5\u5ea6");
        jprelMap.put("\u6db2\u614b", "\u6db2\u4f53\uff08\u614b\uff09");
        jprelMap.put("\u6cb9(\u3042\u3076\u3089)", "\u6cb9");
        jprelMap.put("\u6b21\u7b2c\u306b", "\u3057\u3060\u3044\u306b");
        jprelMap.put("\u3076\u3093\u3074\u3064", "\u5206\u6ccc");
        jprelMap.put("\u3079\u30fc\u305f\u3057\u30fc\u3068", "\u03b2\u30b7\u30fc\u30c8");
        jprelMap.put("\u30d4\u30fc\u30a8\u30c3\u30c1", "pH");
    }

    public KatuyouWriter(String[] args, int version) {
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("k_enjpkey")) {
                this.katuyouEnKey = true;
            } else if (arg.equals("k_jpenkey")) {
                this.katuyouJpKey = true;
            }
            ++i;
        }
        this.katuKey = this.katuyouEnKey || this.katuyouJpKey;
        this.version = version;
    }

    public void addEntry(String jp, String kana, String en, String enTxt, String[] enWords, String[] jpWords, String rel) {
        KEntry entry = new KEntry(jp, kana, en, enTxt, enWords, jpWords, rel);
        if (!this.jp2idMap.containsKey(entry.jp)) {
            this.jp2idMap.put(entry.jp, entry.id);
        }
        this.entries.add(entry);
    }

    private String makeENKey(String[] ens, String[] jps, String jp) {
        if (ens == null || jps == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (ens.length == jps.length) {
            int i = 0;
            while (i < ens.length) {
                if (this.katuyouEnKey) {
                    Util2.appendKey(sb, "*", ens[i], jps[i]);
                }
                if (this.katuyouJpKey && !jps[i].equals(jp)) {
                    Util2.appendKey(sb, "*", jps[i], ens[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < ens.length) {
                if (this.katuyouEnKey) {
                    Util2.appendKey(sb, "*", ens[i], "{" + jp + "}");
                }
                ++i;
            }
            i = 0;
            while (i < jps.length) {
                if (this.katuyouJpKey && !jps[i].equals(jp)) {
                    Util2.appendKey(sb, "*", jps[i], "{" + jp + "}");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    private void parseSentences(StringBuilder sb, String part) {
        String[] stringArray = part.split("\uff0f");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(line = line.trim()).isEmpty()) {
                sb.append(String.valueOf(ZephyrUtil.BR) + "<p>- ");
                sb.append(line);
                sb.append("</p>");
            }
            ++n2;
        }
    }

    private void parseValue(StringBuilder sb, String value) {
        Matcher m = PART_HEAD.matcher(value);
        int idx = 0;
        while (m.find()) {
            if (idx < m.start()) {
                this.parseSentences(sb, value.substring(idx, m.start()));
            }
            sb.append(String.valueOf(ZephyrUtil.BR) + "<p><b>");
            sb.append(m.group(1));
            sb.append("</b></p>");
            idx = m.end();
        }
        if (idx < value.length()) {
            this.parseSentences(sb, value.substring(idx));
        }
    }

    private void initForVer2() {
        this.jp2idMap.put("\u5f97(\u3048)\u308b", 306);
        this.jp2idMap.put("\u7403(\u305f\u307e)", 2193);
        this.jp2idMap.put("\u6570(\u304b\u305a)", 525);
        this.jp2idMap.put("\u7403(\u304d\u3085\u3046)", 785);
    }

    private String rel2href(String jp, String rel) {
        Integer id = null;
        if (this.version == 2) {
            id = this.jp2idMap.get(rel);
        }
        if (id == null) {
            String key = jprelMap.get(rel);
            if (key == null) {
                key = rel;
            }
            id = this.jp2idMap.get(key);
        }
        if (id == null) {
            System.err.println("\u95a2\u9023\u5148\u4e0d\u660e\uff1a" + jp + " - " + rel);
            return rel;
        }
        return "<a href=\"#" + id + "\">" + rel + "</a>";
    }

    private String rel2ref(String jp, String rel) {
        String[] words;
        rel = rel.replaceAll("</?[KR]>", "");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = words = rel.split("[\uff0c,] *");
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.rel2href(jp, word));
            ++n2;
        }
        return sb.toString();
    }

    private void out(int id, String jp, String kana, String en, String enTxts, String[] enWords, String[] jpWords, String rel) {
        StringBuilder sb = new StringBuilder();
        sb.append("<dt id=\"");
        sb.append(id);
        sb.append("\">*");
        sb.append(jp);
        sb.append("\u3010");
        sb.append(kana);
        sb.append("\u3011</dt>");
        if (this.katuKey) {
            sb.append(this.makeENKey(enWords, jpWords, jp));
        }
        sb.append("<dd>");
        if (en != null && en.length() > 0) {
            sb.append(String.valueOf(ZephyrUtil.BR) + "<p>* ");
            sb.append(en);
            sb.append("</p>");
        }
        if (enTxts != null && enTxts.length() > 0) {
            this.parseValue(sb, enTxts);
        }
        if (enWords != null && enWords.length > 0) {
            sb.append(String.valueOf(ZephyrUtil.BR) + "<p><b>\u82f1</b> - ");
            Util2.numbering(sb, enWords);
            sb.append("</p>");
        }
        if (jpWords != null && jpWords.length > 0) {
            sb.append(String.valueOf(ZephyrUtil.BR) + "<p><b>\u548c</b> - ");
            Util2.numbering(sb, jpWords);
            sb.append("</p>");
        }
        if (rel != null && rel.length() > 0) {
            sb.append(String.valueOf(ZephyrUtil.BR) + "<p><b>\u95a2\u9023</b> - ");
            sb.append(this.rel2ref(jp, rel));
            sb.append("</p>");
        }
        sb.append("</dd>");
        String txt = sb.toString();
        txt = txt.replace("over the range 0 < <I>x</I> < 1.2", "over the range 0 &lt; <I>x</I> &lt; 1.2");
        txt = Util.normalize(txt);
        txt = Gaiji.convert(txt);
        System.out.println(txt);
    }

    public void out() {
        if (this.version == 2) {
            this.initForVer2();
        }
        System.out.println("<html><body>");
        for (KEntry entry : this.entries) {
            this.out(entry.id, entry.jp, entry.kana, entry.en, entry.enTxts, entry.enWords, entry.jpWords, entry.rel);
        }
        System.out.println("</body></html>");
        System.err.println(String.valueOf(this.entries.size()) + "\u9805\u76ee");
    }

    private static class KEntry {
        private final int id;
        private final String jp;
        private final String kana;
        private final String en;
        private final String enTxts;
        private final String rel;
        private final String[] enWords;
        private final String[] jpWords;

        KEntry(String jp, String kana, String en, String enTxts, String[] enWords, String[] jpWords, String rel) {
            int n = nextId;
            nextId = n + 1;
            this.id = n;
            this.jp = KEntry.trim(jp);
            this.kana = KEntry.trim(kana);
            this.en = KEntry.trim(en);
            this.enTxts = KEntry.trim(enTxts);
            this.enWords = enWords;
            this.jpWords = jpWords;
            this.rel = KEntry.trim(rel);
        }

        private static String trim(String txt) {
            return txt != null ? txt.trim() : null;
        }
    }
}

