/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import zephyr.kagakudoujin.kagakueigo.Util;

public class FileLoader {
    static LinkedList<byte[]> load(File file, byte[] delim) throws Exception {
        return FileLoader.load(file, delim, 0);
    }

    static LinkedList<byte[]> load(File file, byte[] delim, int startOffset) throws Exception {
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        BinData bdata = new BinData();
        byte[] buffer = FileLoader.loadBinary(file);
        if (buffer == null) {
            return result;
        }
        int start = Util.findData(buffer, startOffset, buffer.length, delim);
        while (start < buffer.length) {
            int end;
            if ((start += delim.length) == (end = Util.findData(buffer, start, buffer.length, delim))) continue;
            if (start < end) {
                bdata.add(buffer, start, end);
                result.add(bdata.get());
                bdata.clear();
                start = end;
                continue;
            }
            bdata.add(buffer, start, buffer.length);
            result.add(bdata.get());
            break;
        }
        return result;
    }

    static byte[] loadBinary(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        BufferedInputStream bin = new BufferedInputStream(in);
        byte[] buffer = new byte[(int)file.length()];
        int readlen = bin.read(buffer, 0, buffer.length);
        bin.close();
        if ((long)readlen == file.length()) {
            return buffer;
        }
        return null;
    }

    private static class BinData {
        private byte[] data = null;

        private BinData() {
        }

        void add(byte[] buffer, int start, int end) {
            int len = end - start;
            if (this.data == null) {
                this.data = Arrays.copyOfRange(buffer, start, end);
            } else {
                byte[] newdata = Arrays.copyOf(this.data, this.data.length + len);
                System.arraycopy(buffer, 0, newdata, this.data.length, len);
                this.data = newdata;
            }
        }

        byte[] get() {
            return this.data;
        }

        void clear() {
            this.data = null;
        }

        public String toString() {
            if (this.data == null) {
                return "null";
            }
            try {
                String s = new String(this.data, "Windows-31J");
                return s;
            }
            catch (UnsupportedEncodingException e) {
                return "?";
            }
        }
    }
}

