/*
 * Decompiled with CFR 0.152.
 */
package zephyr.iwanami.koujien;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DicBody {
    private final ArrayList<String> lemmaList = new ArrayList();
    private final HashSet<String> lemmaSet = new HashSet();
    private final ArrayList<String> ddList = new ArrayList();
    private final HashMap<String, String> kana2hyokiMap = new HashMap(250000);
    private final HashMap<String, String> hyoki2kanaMap = new HashMap(250000);
    private static final Pattern DT = Pattern.compile("<dt[^<>]*>(.+)</dt><dd><p>(.+)</p></dd>");
    private static final Pattern LEMMA5_KANA1 = Pattern.compile("(([^\u2010]+?)\u2010[^\u2010]+?\u3010)\u2015(.+?\u3011)");
    private static final Pattern LEMMA5_KANA2 = Pattern.compile("([^\u2010]+?\u2010([^\u2010]+?)\u3010[^\u2010]+?)\u2015(\u3011)");
    private static final String MULTI = "MULTI";

    public DicBody(String filename) throws Exception {
        this.load(filename);
    }

    private static String normalizeLemma(String lemma) {
        lemma = lemma.replaceAll("<sub>[^<>]+</sub>", "");
        return lemma;
    }

    private static String normalizeLemma5(String lemma5) {
        int idx;
        Matcher m = LEMMA5_KANA1.matcher(lemma5);
        if (m.find()) {
            lemma5 = String.valueOf(m.group(1)) + m.group(2) + m.group(3);
        }
        if ((m = LEMMA5_KANA2.matcher(lemma5)).find()) {
            lemma5 = String.valueOf(m.group(1)) + m.group(2) + m.group(3);
        }
        if ((idx = lemma5.indexOf(12304)) > 0) {
            lemma5 = String.valueOf(lemma5.substring(0, idx)) + lemma5.substring(idx).replace('\u2010', '-');
        }
        lemma5 = lemma5.replaceFirst("(\u3010[\\x00-\\x7F]+[\\x21-\\x7F])([\\x80-\\uFFFF]+\u3011)", "$1 $2");
        return lemma5;
    }

    private void put(String key, String value, HashMap<String, String> map) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        } else {
            map.put(key, MULTI);
        }
    }

    private void load(String filename) throws Exception {
        String line;
        File file = new File(filename);
        if (!file.canRead()) {
            System.err.println("cannot find/read " + filename);
            return;
        }
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        while ((line = br.readLine()) != null) {
            Matcher m = DT.matcher(line);
            if (!m.find()) continue;
            String lemma = DicBody.normalizeLemma5(DicBody.normalizeLemma(m.group(1)));
            this.lemmaList.add(lemma);
            this.lemmaSet.add(lemma);
            this.ddList.add(m.group(2));
            int idx = lemma.indexOf(12304);
            if (idx <= 0) continue;
            String kana = lemma.substring(0, idx);
            String hyoki = lemma.substring(idx + 1, lemma.length() - 1);
            this.put(kana, hyoki, this.kana2hyokiMap);
            this.put(hyoki, kana, this.hyoki2kanaMap);
        }
        br.close();
        System.err.println("load " + this.lemmaList.size() + " lemmas from " + filename);
    }

    public ArrayList<String> getLemmas() {
        return this.lemmaList;
    }

    public ArrayList<String> getDD() {
        return this.ddList;
    }

    public boolean hasLemma(String lemma) {
        return this.lemmaSet.contains(lemma);
    }

    public String getHyoki(String kana) {
        String hyoki = this.kana2hyokiMap.get(kana);
        if (hyoki != null && hyoki != MULTI) {
            return hyoki;
        }
        return null;
    }

    public String getKana(String hyoki) {
        String kana = this.hyoki2kanaMap.get(hyoki);
        if (kana != null && kana != MULTI) {
            return kana;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30af\u2010\u3068\u3046\u3010\u2015\u706f\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30b5\u30fc\u304a\u3046\u2010\u3082\u306e\u304c\u305f\u308a\u3010\u2015\u738b\u7269\u8a9e\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30c8\u30de\u30f3\u3010&#xA126;tman\u68b5\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30fc\u30c8\u30de\u30f3\u3010&#xA126;tman \u68b5\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u30a2\u30f4\u30a1\u30f3\u2010\u30ae\u30e3\u30eb\u30c9\u3010avant-garde\u30d5\u30e9\u30f3\u30b9\u3011"));
        System.out.println(DicBody.normalizeLemma5("\u3042\u304b\u2010\u30af\u30ed\u30fc\u30d0\u30fc\u3010\u8d64\u2015\u3011"));
    }
}

