# prime/engine/engine-number.rb
# $Id: engine-number.rb,v 1.1.2.3 2004/01/26 06:39:40 komatsu Exp $
#
# Copyright (C) 2002, 2003, 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine'
$engine_class_name = 'PrimeEngineNumber'

class PrimeEngineNumber < PrimeEngine
  def initialize
    super

    @name = "Number engine"
    @id   = "number"
    @description = "Number engine"
  end

  def search(query)
    case query.method
    when :overall then
      results = search_overall(query)
    else
      results = PrimeWordList.new()
    end
    return results
  end

  private
  def search_overall(query)
    results = PrimeWordList.new()
    query.input.each {|string|
      calculation = calc(string)
      if calculation then
        results << PrimeWord.new(calculation, calculation, "ü", 20000)
      end
    }
    return results
  end

  def calc (string)
    if string =~ /[-+*\/ 0-9()]+=$/ then
      begin
	return eval(string[0..-2]).to_s
      rescue
	return nil
      end
    end
    return nil
  end

  def taiyaki (string)
    string_numbers     = string.split(/[^0-9]+/)
    if string_numbers == [] then
      return nil
    else
      string_non_numbers = string.split(/[0-9]+/)
      return string_non_numbers.join("#")
    end
  end
end
