#### prime-userdict.rb: Library for userdict of PRIME.
#### $Id: basicdict.rb,v 1.1.2.3 2003/12/31 09:26:42 komatsu Exp $
####
#### Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
####     All rights reserved.
####     This is free software with ABSOLUTELY NO WARRANTY.
####
#### You can redistribute it and/or modify it under the terms of 
#### the GNU General Public License version 2.

require 'prime/taiyaki'
require 'progressbar'
require 'prime/makedict/prime-sary' # For PrimeMakeIndex

class PrimeBasicdict < PrimeSaryMakeIndex
  def initialize(dictname, is_interactive = true)
    super(dictname)
  end

  def make_pos_table(is_interactive = @is_interactive)
    pos_table         = {}
    pos_table_literal = {}
    label = is_interactive ? "DICT LOADING" : nil
    File::open(@dictname, "r").each_with_pbar(label) {|line|
      (pron, pos, literal, *rest) = line.chomp.split(/\t/)
      if pos_table[pron].nil? then
	pos_table[pron] = [pos]
      elsif pos_table[pron].member?(pos) == false then
	pos_table[pron].push(pos)
      end
      if pos_table_literal[literal].nil? then
	pos_table_literal[literal] = [pos]
      elsif pos_table_literal[literal].member?(pos) == false then
	pos_table_literal[literal].push(pos)
      end
    }

    File::open(@dictname + "-pos", "w") {|io|
      label = is_interactive ? "POS WRITING" : nil
      pos_table.keys.sort.each_with_pbar(label) {|pron|
	line = [pron, *pos_table[pron]].join("\t")
	io.puts(line)
      }
    }
    File::open(@dictname + "-pos_literal", "w") {|io|
      label = is_interactive ? "POS WRITING #2" : nil
      pos_table_literal.keys.sort.each_with_pbar(label) {|literal|
	line = [literal, *pos_table_literal[literal]].join("\t")
	io.puts(line)
      }
    }
  end
end

if File::expand_path($0) == File::expand_path(__FILE__) then
  dicttool = PrimeBasicdict.new(ARGV[0])
  dicttool.make_pos_table()
  dicttool.make_basicdict_indexes()
end
