# prime/engine/engine-alphabet.rb
# $Id: engine-alphabet.rb,v 1.3.2.6 2004/01/28 08:34:56 komatsu Exp $
#
# Copyright (C) 2002, 2003, 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine'
$engine_class_name = 'PrimeEngineAlphabet'

class PrimeEngineAlphabet < PrimeEngine
  def initialize
    super

    @name = "Alphabet engine"
    @id   = "alphabet"
    @description = "Alphabet engine"
  end

  def search(query)
    if query.input == [""] then
      return PrimeWordList.new()
    end

    case query.method
    when :overall then
      results = search_overall(query)
    else
      results = PrimeWordList.new()
    end
    return results
  end

  private
  def search_overall(query)
    results = PrimeWordList.new()
    query.input.each {|string|
      if string == string.upcase and string != string.downcase then
        results << PrimeWord.new(string.downcase, string,
                                 "̤θ", 17000) # ñ(ʸ)
      else
        results << PrimeWord.new(string.downcase, string,
                                 "̤θ", 8000) # ñ
      end
      ### FIXME: 㤦󥸥Ѥ.
      (hiragana, pending) = PrimeTypeConv::convert(string)
      if pending.empty? then
        results << PrimeWord.new(hiragana, hiragana.katakana,
                                 "̤θ", 8000) # 
        results << PrimeWord.new(hiragana, hiragana,
                                 "̤θ", 8000) # Ҥ餬ʤʤ
      end
    }
    return results
  end
end
