dnl acinclude.m4: m4 macros for Autoconf
dnl $Id: acinclude.m4,v 1.1.1.1.2.2 2004/01/21 06:34:01 komatsu Exp $
dnl
dnl Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
dnl     All rights reserved.
dnl     This is free software with ABSOLUTELY NO WARRANTY.
dnl
dnl You can redistribute it and/or modify it under the terms of 
dnl the GNU General Public License version 2.

AC_DEFUN(AC_INIT_DEFAULT_VALUES,
[
test "x$prefix" = xNONE && prefix=$ac_default_prefix
test "x$exec_prefix" = xNONE && exec_prefix=$prefix
])
AC_DEFUN(AC_VAR_EXPAND, [`eval echo $1`])


AC_DEFUN(MY_AC_PROG_RUBY,
[
    AC_SUBST(ruby_version,
        [`ruby -r rbconfig -e "puts Config::CONFIG[['ruby_version']]"`])
])

AC_DEFUN(AC_RUBY_SITELIBDIR,
    ['$(libdir)/site_ruby/$(ruby_version)'])
#    [`ruby -r rbconfig -e "puts Config::MAKEFILE_CONFIG[['rubylibdir']]"`])

AC_DEFUN(MY_AC_PROG_PYTHON,
[
  AM_PATH_PYTHON() 
  AC_CACHE_CHECK([for Python include path], [am_cv_python_include],
    [am_cv_python_include=`$PYTHON -c "from distutils.sysconfig import *; print get_python_inc()"`])
  AC_SUBST([PYTHON_CFLAGS], [-I$am_cv_python_include])
  AC_SUBST([PYTHON_LIBS], [-lpython$PYTHON_VERSION])
])

AC_DEFUN(MY_AC_PROG_SWIG,
[
  AC_REQUIRE([AC_EXEEXT])
  AC_PATH_PROG(SWIG, swig$EXEEXT, NONE)
  if test "$SWIG" = NONE; then
    AC_MSG_ERROR([swig is not found in $PATH])
  fi;
])
