;; $Id: prime-conv-mode.el,v 1.1 2003/05/31 19:37:20 komatsu Exp $

(defun prime-conv-mode (&optional arg)
  (setq prime-conv-mode 
	(if (null arg) (not prime-conv-mode)
	  (> (prefix-numeric-value arg) 0)))
  (if prime-conv-mode
      (prime-conv-mode-on t)
    (prime-conv-mode-off t)
    ))

(defun prime-conv-mode-on (&optional forcep)
  (if (or forcep (not prime-conv-mode))
      (progn
	(prime-input-mode-on)
	(setq prime-conv-mode t)
	;;;; FIX ME: $B$3$3$G$d$k$Y$-$b$N$G$O$J$$(B.
	;;;; $BJQ498uJd$r<hF@$7D>$9(B. (for Pogemo server)
;	(prime-set-cands prime-pat t)
	(setq prime-cands
	      (mell-list-uniq (append prime-cands (prime-search prime-pat))))
	)))
  
(defun prime-conv-mode-off (&optional forcep)
  (if (or forcep prime-conv-mode)
      (progn
	(setq prime-conv-mode nil)
	(prime-cand-mode-off)
;	(prime-narrow-mode-off)
	(setq prime-nth-cand 0)
	(prime-input-mode-reset)
	)))


;;;; ------------------------------------------------------------
;;;; $B4X?tDj5A(B
;;;; ------------------------------------------------------------

;; $B$3$l$C$FJ,$1$k$Y$-$+$J(B?
;; $B<!$N8uJd$K0\F0(B. (prime-conv-mode)
(defun prime-conv-next ()
  (interactive)
  (if prime-conv-mode
      (cond 
       ((>= (1+ prime-nth-cand) (length prime-cands))
	(prime-register-word prime-pat))
       ((> prime-nth-cand 1) ;; $B2?2sL\$NJQ49$G8uJd$rA4I=<($K$9$k$+(B? (N +3)
	(prime-cand-mode-on)
	(setq prime-nth-cand (1+ prime-nth-cand))
	(prime-disp-conv))
       (prime-cands
	(setq prime-nth-cand (1+ prime-nth-cand))
	(prime-disp-conv))
       )
    (prime-conv-mode-on)
    (setq prime-nth-cand 0)
    (prime-disp-conv)
   ))

(defun prime-conv-prev ()
  (interactive)
  (setq prime-nth-cand (1- prime-nth-cand))
  (if (>= prime-nth-cand 0)
      (prime-disp-conv)
    (prime-conv-mode-off)
    (prime-disp-input)
    ))

(defun prime-selcand ()
  (prime-disp-conv)
  (setq prime-nth-cand (1+ prime-nth-cand))
  )

(defalias 'prime-prevcand 'prime-conv-prev)

(defun prime-conv-decide ()
  (interactive)
  (cond
   (prime-conv-mode
    (prime-fix prime-curstr)
    (prime-after-fix))
   ((= prime-input-column (length prime-pat)) ;; input-mode
    (if prime-context
	(prime-fix prime-curstr)
      (prime-fix-without-learn prime-curstr))
    (prime-after-fix))
   (t  ;;input-mode $B$NJT=8Cf(B
    (prime-input-split))
   ))

(defun prime-conv-exact ()
  (interactive)
  (setq prime-conv-exact-p (not prime-conv-exact-p))
  (setq prime-nth-cand 0)  ;; 0?
  (prime-set-cands prime-pat t)
  (and prime-cand-mode
       (prime-cand-mode-on t))
  (prime-disp-conv)
  )

(defun prime-conv-cancel-all ()
  (interactive)
  (prime-erase-cand-list)
  (prime-erase-curstr)
  (insert prime-start-pat)
  (prime-reset-after-fix)
  (setq prime-next-pattern "")
  (prime-fund-mode-on))
  
; $BJQ49ESCf$G$"$l$P(B, $B:G=i$N8uJd$K(B.
; $B:G=i$N8uJd$G$"$l$P(B, $B%-%c%s%;%k(B.
(defun prime-conv-cancel ()
  (interactive)
  (cond (prime-narrow-mode
	 (prime-narrow-mode-off)
	 (prime-disp-conv))
	(prime-conv-mode
	 (prime-conv-mode-off)
	 (prime-disp-input))
	(t
	 (prime-conv-cancel-all))
	))

(defun prime-conv-cand-list ()
  (interactive)
  (and (< (count-lines (point) (window-end nil t)) 4)
       (recenter))
  (prime-cand-mode-on)
  (prime-disp-conv))

(provide 'prime-conv-mode)
