# prime/engine/engine-kukura.rb
# $Id: engine-kukura.rb,v 1.1.1.1 2003/05/28 17:48:18 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'sary'
require 'prime/engine/engine-japanese'

$engine_class_name = 'PrimeEngineKukura'

class PrimeEngineKukura < PrimeEngineJapanese
  def initialize
    super

    @name = "Kukura engine"
    @id   = "kukura"
    @description = "Kukura engine"

    @kukura_path = ENV["HOME"] + '/var/kukura/prime'
    @max_candidates = 15
  end

  private
  def lookup (input, method = :prefix)
    results = PrimeResult.new
    queries = make_queries(input.base)
    if method == :prefix then
      input.expands.each {|string|
	queries.add(string) 
      }
      rests = queries.rests
      max   = @max_candidates
    else
      queries.add(input.original, nil, "", "", false)
      rests = [""]
      max   = 100
    end

    lookup_dict(queries.query_lines, max).each {|line|
      (pattern, part, word, freq) = line.split(/\t/)
      cand = PrimeCandidate.new(pattern, word, 9600 + (freq.to_i * 500), part)
      results << cand
    }
    return results
  end

  def lookup_dict (query_lines, max = nil)
    results = []
    dict_files = dict()
    return results if max == nil or max == 0 or dict_files == nil

    i = 0
    dict_files.each {|dict_file|
      next unless File::exist?(dict_file + ".ary")
      sary = Sary::Searcher.new(dict_file)
      if !(query_lines.empty?) and sary.multi_search(query_lines) then
	sary.sort_occurrences
	while line = sary.get_next_context_line do
	  (yomi, part, word, freq) = line.chomp.split(/\t/)
	  freq = freq.to_i - (i * 2)
	  results << [yomi, part, word, freq].join("\t")
#	  results << line.chomp
	  if max and (results.length == max) then
	    break
	  end
	end
      end
      i += 1
    }
    return results
  end
  
  def dict
    dict = `cat #{@kukura_path}/recentfiles.txt|grep ^1|head -10|cut -f3`
    return dict.map {|file|
      @kukura_path + "/" + file.chomp
    }
  end

  def lookup_part (base)
    return [base]
  end
end
