# dictformat-skk.rb: Converter module for skk format.
# $Id: dictformat-skkdic.rb,v 1.4 2004/12/31 06:23:31 komatsu Exp $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/makedict/dictformat'
$KCODE = 'e'

class DictFormatSkkdic < DictFormat
  def initialize (is_interactive = true)
    super(is_interactive)
    @default_pos  = nil
    @default_freq = 0
    @default_attr = nil
  end

  def parse (line)
    return nil if line =~ /^ *;/
    results = []

    line.chomp!
    (pron, *words) = line.split(/\//)
    pron.strip!
    words.each{|word|
      if valid_word?(pron, word) then
	(literal, attr) = word.split(';')
        if attr then
          comment = "comment=#{attr}"
          results << [pron, @default_pos, literal, @default_freq, comment]
        else
          results << [pron, @default_pos, literal, @default_freq]
        end
      end
    }
    return results
  end

  private
  def valid_word? (pron, word)
    return ((pron.length > 0) and taigen?(pron))
  end

  def taigen? (pron)
    return pron !~ /^[^a-z].*[a-z]$/
  end
end
