# prime/engine/engine-alphabet.rb
# $Id: engine-alphabet.rb,v 1.8 2004/12/09 12:24:15 komatsu Exp $
#
# Copyright (C) 2002, 2003, 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine'
$engine_class_name = 'PrimeEngineAlphabet'

class PrimeEngineAlphabet < PrimeEngine
  @@annotations = {
    "-"  => "Ⱦѡ֥ޥʥ",
    "" => "ѡ֥ޥʥ",
    "" => "Ĺ",
    "" => "",
    "" => "֤",
    "" => "֥å",
    "" => "֥ϥե",
    "x"  => "Ⱦѡ֥å",
    "X"  => "Ⱦѡ֥å",
    "" => "ѡ֥å",
    "" => "ѡ֥å",
    "" => "֤",
    "o"  => "Ⱦѡ֥",
    "O"  => "Ⱦѡ֥",
    "0"  => "Ⱦѡ֥",
    "" => "ѡ֥",
    "" => "ѡ֥",
    "" => "ѡ֥",
    "" => "֥",
    "" => "֤ޤ",
    "" => "֤ޤ2",
    "" => "ѥ",
    "" => "֤ˡ",
    "" => "Ҥ餬",
    "" => "",
    "" => "Ҥ餬",
    "" => "",
    "|"  => "Ⱦ",
    "" => "",
    "."  => "Ⱦ",
    "" => "",
    ","  => "Ⱦ",
    "" => "",
  }

  def initialize
    super

    @name = "Alphabet engine"
    @id   = "alphabet"
    @description = "Alphabet engine"
  end

  def search(query)
    if query.input == [""] then
      return PrimeWordList.new()
    end

    case query.method
    when :overall then
      results = search_overall(query)
    else
      results = PrimeWordList.new()
    end
    if query.pos == '' then
      query.input.each {|input|
        numeral = PrimeWord.new(input, input, query.pos, 10000)
        results.push(numeral)
      }
    end
    return results
  end

  def get_pos_data (string)
    pos_data = {}
    if string =~ /^[0-9.,+-]+/ then
      matched_string = $&
      pos_data.list_push(matched_string, '')
    end
    return pos_data
  end

  private
  def search_overall(query)
    results = PrimeWordList.new()
    query.input.each {|string|
      if PRIME_ENV['typing_method'] == 'tcode' then
        if string.length == 1 then 
          results << PrimeWord.new(string.downcase, string,
                                   "ü", 20000) # T-Code Ǥ 1ʸ
        end
      end
      if string == string.upcase and string != string.downcase then
        results << PrimeWord.new(string.downcase, string,
                                 "̤θ", 17000) # ñ(ʸ)
      else
        results << PrimeWord.new(string.downcase, string,
                                 "̤θ", 8000) # ñ
      end
      ### FIXME: 㤦󥸥Ѥ.
      (hiragana, pending) = PrimeTypeConv::convert(string)
      if pending.empty? then
        results << PrimeWord.new(hiragana.downcase, hiragana.katakana,
                                 "̤θ", 8000) # 
        results << PrimeWord.new(hiragana.downcase, hiragana,
                                 "̤θ", 8000) # Ҥ餬ʤʤ
      end
    }

    results.each { | word |
      if @@annotations.has_key?( word.literal ) and
          (not word.data.has_key?('annotation')) then
        word.data['annotation'] = @@annotations[ word.literal ]
      end
    }
    return results
  end
end
