# prime/prime-mixed.rb
# $Id: prime-mixed.rb,v 1.2 2004/03/25 17:19:49 komatsu Exp $
#
# Copyright (C) 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

module PrimeMixed
  def lookup_mixed (string, max = 10)
    string = PrimeTypeConv::convert(string).join()
    data_list = process_data(string)
    results  = lookup_mixed_concat_data_list(data_list)
    return PrimeWordList::merge_with_label(@context, results)
  end

  def process_data (pattern)
    if pattern.empty? then
      return []
    end

    chars = pattern.split(//)
    
    chars.length.step(1, -1) {|l|
      pattern1 = chars[0,l].join()
      pattern2 = chars[l..-1].join()

      query = PrimeQuery.new([pattern1], nil, :exact)
      words = search(query)
      literals = words.map{|word| word.literal }.compact
      unless literals.empty? then
        return [[[pattern1], literals], *process_data(pattern2)]
      end

      query = PrimeQuery.new([pattern1], nil, :literal_exact)
      words = search(query)
      prons = words.map{|word| word.pron }.compact
      unless prons.empty? then
        return [[prons, [pattern1]], *process_data(pattern2)]
      end
    }
    pattern1 = chars[0,1].join()
    pattern2 = chars[1..-1].join()
    return [[[pattern1], [pattern1]], *process_data(pattern2)]
  end

  def lookup_mixed_concat_data_list (data_list)
    data = [["", ""]]
    last_data = data_list.pop()
    data_list.each {|data2|
      tmp_data = []
      data.each {|(pron1, literal1)|
        data2[1].each {|literal2|
          literal = literal1 + literal2
          query = PrimeQuery.new([literal], nil, :literal_exact)
          words = search(query)
          words.each {|word|
            data2[0].each {|pron2|
              if word.pron == (pron1 + pron2) then
                unless tmp_data.member?([word.pron, word.literal])
                  tmp_data.push([word.pron, word.literal]) 
                end
              end
            }
          }            
        }
      }
      data = tmp_data
    }

    results = PrimeWordList.new()
    data.each {|(pron1, literal1)|
      last_data[1].each {|literal2|
        literal = literal1 + literal2

        query = PrimeQuery.new([literal], nil, :literal_exact)
        words = search(query)
        words.each {|word|
          last_data[0].each {|pron2|
            if word.pron == (pron1 + pron2) then
              results << word
            end
          }
        }
      }
    }
    return results
  end
end
