//
// Lib.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Utilities;
import java.io.*;
import java.util.Locale;

class Lib {
	// FileType
	public final static int FT_NONE = 0;
	public final static int FT_PDF = 1;
	public final static int FT_BMP = 2;
	public final static int FT_GIF = 3;
	public final static int FT_JBIG2 = 4;
	public final static int FT_JPEG = 5;
	public final static int FT_JPEG2000 = 6;
	public final static int FT_PNG = 7;
	public final static int FT_TIFF = 8;
	public final static int FT_WMF = 9;
	public final static int FT_OTHERIMAGE = 10;

	//
	public final static double UNIT_POINT_POINT = 1.0;
	public final static double UNIT_POINT_INCH = Utilities.pointsToInches(1);
	public final static double UNIT_POINT_MM = Utilities.pointsToMillimeters(1);
	public final static double UNIT_POINT_CM = UNIT_POINT_MM / 10;
	public final static double UNIT_POINT_M = UNIT_POINT_MM / 1000;
	public final static double UNIT_PIXEL_PIXEL = 1.0;

	public static int getImageFileType(Image image) {
		switch (image.getOriginalType()) {
		case Image.ORIGINAL_BMP:
			return FT_BMP;
		case Image.ORIGINAL_GIF:
			return FT_GIF;
		case Image.ORIGINAL_JBIG2:
			return FT_JBIG2;
		case Image.ORIGINAL_JPEG:
			return FT_JPEG;
		case Image.ORIGINAL_JPEG2000:
			return FT_JPEG2000;
		case Image.ORIGINAL_PNG:
			return FT_PNG;
		case Image.ORIGINAL_TIFF:
			return FT_TIFF;
		case Image.ORIGINAL_WMF:
			return FT_WMF;
		default:
			return FT_OTHERIMAGE;
		}
	}

	public static String getFileTypeName(int fileType) {
		switch (fileType) {
		case FT_PDF:
			return "PDF ";
		case FT_BMP:
			return "BMP ";
		case FT_GIF:
			return "GIF";
		case FT_JBIG2:
			return "JBIG2";
		case FT_JPEG:
			return "JPEG";
		case FT_JPEG2000:
			return "JPEG 2000";
		case FT_PNG:
			return "PNG";
		case FT_TIFF:
			return "TIFF";
		case FT_WMF:
			return "WMF";
		case FT_OTHERIMAGE:
			return "IMAGE";
		default:
			return "";
		}
	}

	private static Localization localization = new Localization();
	static {
		localization.addLanguageMessages(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry());
	}

	public static String getMessage(String key) {
		return localization.getMessage(key);
	}

	public static byte[] FileReadAllBytes(File file) throws Exception {
		// TODO:
		FileInputStream is;
		is = new FileInputStream(file);
		int length = is.available();
		byte[] data = new byte[length];
		is.read(data);
		is.close();
		return data;
	}
}

class PaperSize {
	public final static PaperSize A0 = new PaperSize(PageSize.A0);
	public final static PaperSize A1 = new PaperSize(PageSize.A1);
	public final static PaperSize A2 = new PaperSize(PageSize.A2);
	public final static PaperSize A3 = new PaperSize(PageSize.A3);
	public final static PaperSize A4 = new PaperSize(PageSize.A4);
	public final static PaperSize A5 = new PaperSize(PageSize.A5);
	public final static PaperSize A6 = new PaperSize(PageSize.A6);
	public final static PaperSize B0 = new PaperSize(PageSize.B0);
	public final static PaperSize B1 = new PaperSize(PageSize.B1);
	public final static PaperSize B2 = new PaperSize(PageSize.B2);
	public final static PaperSize B3 = new PaperSize(PageSize.B3);
	public final static PaperSize B4 = new PaperSize(PageSize.B4);
	public final static PaperSize B5 = new PaperSize(PageSize.B5);
	public final static PaperSize B6 = new PaperSize(PageSize.B6);
	public final static PaperSize CUSTOM = new PaperSize(true, 0, 0);

	private boolean custom;
	private float width;
	private float height;

	public boolean isCustom() {
		return this.custom;
	}

	public float getWidth() {
		return this.width;
	}

	public float getHeight() {
		return this.height;
	}

	public PaperSize(boolean custom, float width, float height) {
		this.custom = custom;
		this.width = width;
		this.height = height;
	}

	private PaperSize(Rectangle rect) {
		this.custom = false;
		this.width = rect.getWidth();
		this.height = rect.getHeight();
	}
}
