// Pochy Plugin Copyright(C) 2004 minamina
// CPlugin & CPluginManager class

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#if !defined(AFX_PLUGIN_H__B625EB6C_E1F7_4C30_9064_4432B9D516D0__INCLUDED_)
#define AFX_PLUGIN_H__B625EB6C_E1F7_4C30_9064_4432B9D516D0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning (push, 1)
#include <string>
#include <vector>
#pragma warning (pop)
#include "PochyPlugin.h"

class CPlugin
{
public:
	struct CInfo
	{
		std::string m_name;
		std::string m_version;
		std::string m_copyright;
		std::string m_comments;
	};

	void OnInitMenu(HMENU hMenu, POCHY_MENU_TYPE nPocnyMenuType);
	void OnFetchFinished(LPCTSTR lpszAccountName, const int nFetchCount);
	void OnPostFilter(LPCTSTR lpszMailSaveFilename);
	void OnPreFilter(LPCTSTR lpszRawMessage, LPTSTR lpszMailSavePath);
	void OnActivate(UINT nState);
	void OnFolderChanged(LPCTSTR lpszFolderName);
	void OnAccountChanged(LPCTSTR lpszAccountName);
	POCHY_RESULT_TYPE OnSendMail(LPCTSTR lpszRawMessage);
	void OnOpenDraft(HWND hDraftWindow);
	void OnTextViewChanged(BOOL bShow);
	POCHY_RESULT_TYPE OnClose();
	void OnOpen();
	void OnUnloadPlugin();
	void OnLoadPlugin();
	bool OnPluginCheck();
	bool IsPreFilterPlugin();
	const std::string GetPluginDllName();
	const CInfo& GetInfo() const;
	bool IsValid();
	bool LoadLibrary(const std::string& path);
	void FreeLibrary();
	CPlugin();
	virtual ~CPlugin();

private:
	std::string m_dllPath;
	CInfo m_info;

	HMODULE  m_hModule;

	void (WINAPI* PC_OnInitMenu)(HMENU hMenu, POCHY_MENU_TYPE nPochyMenuType);
	void (WINAPI* PC_OnFetchFinished)(LPCTSTR lpszAccountName, const int nFetchCount);
	void (WINAPI* PC_OnPostFilter)(LPCTSTR lpszMailSaveFilename);
	void (WINAPI* PC_OnPreFilter)(LPCTSTR lpszRawMessage, LPTSTR lpszMailSavePath);
	void (WINAPI* PC_OnActivate)(UINT nState);
	void (WINAPI* PC_OnFolderChanged)(LPCTSTR lpszFolderName);
	void (WINAPI* PC_OnAccountChanged)(LPCTSTR lpszAccountName);
	void (WINAPI* PC_OnOpenDraft)(HWND hDraftWindow);
	POCHY_RESULT_TYPE (WINAPI* PC_OnSendMail)(LPCTSTR lpszRawMessage);
	void (WINAPI* PC_OnTextViewChanged)(BOOL bShow);
	POCHY_RESULT_TYPE (WINAPI* PC_OnClose)();
	void (WINAPI* PC_OnOpen)();
	void (WINAPI* PC_OnUnloadPlugin)();
	void (WINAPI* PC_OnLoadPlugin)();
	void (WINAPI* PC_OnPluginCheck)(POCHY_PLUGIN_INFO*);
};

class CPluginManager  
{
public:
	void OnInitMenu(HMENU hMenu, POCHY_MENU_TYPE nPochyMenuType);
	void OnFetchFinished(LPCTSTR lpszAccountName, const int nFetchCount);
	void OnPostFilter(LPCTSTR lpszMailSaveFilename);
	void OnPreFilter(LPCTSTR lpszRawMessage, LPTSTR lpszMailSavePath);
	void OnActivate(UINT nState);
	void OnFolderChanged(LPCTSTR lpszFolderName);
	void OnAccountChanged(LPCTSTR lpszAccountName);
	void OnOpenDraft(HWND hDraftWindow);
	POCHY_RESULT_TYPE OnSendMail(LPCTSTR lpszRawMessage);
	void OnTextViewChanged(BOOL bShow);
	POCHY_RESULT_TYPE OnClose();
	void OnOpen();
	void OnUnloadPlugin();
	void OnLoadPlugin();
	void UnloadAllPlugins();
	void LoadAllPlugins();
	bool HasPreFilterPlugin();
	typedef std::vector<CPlugin> PLUGIN_LIST;
	const PLUGIN_LIST& GetPluginList();
	CPluginManager();
	virtual ~CPluginManager();

private:
	bool m_bHasPreFilterPlugin;
	const std::string GetPluginPath();
	PLUGIN_LIST m_pluginList;
};

#endif // !defined(AFX_PLUGIN_H__B625EB6C_E1F7_4C30_9064_4432B9D516D0__INCLUDED_)
