// Pochy Exports API Copyright(C) 2004 minamina

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "stdafx.h"
#include <assert.h>
#include "PochyPlugin.h"
#include "pochy.h"
#include "MainFrm.h"
#include "DraftFrame.h"

static TCHAR NULL_STRING[] = _T("");

LPCTSTR WINAPI PA_GetVersionString()
{
	static TCHAR tcVersion[] = VERSION;
	return tcVersion;
}

// AvP[V̂tH_[Ԃ
LPCTSTR WINAPI PA_GetAppPath()
{
	CPochyApp* pPochyApp = (CPochyApp*)::AfxGetApp();
	if (pPochyApp != NULL)
	{
		return pPochyApp->m_app_path;
	}
	return NULL_STRING;
}

CMainFrame* GetMainFrame()
{
	CPochyApp* pPochyApp = (CPochyApp*)::AfxGetApp();
	if (pPochyApp != NULL)
	{
		return (CMainFrame*)pPochyApp->m_pMainWnd;
	}
	return NULL;
}

CTextView* GetTextView()
{
	CMainFrame* pMainFrame = GetMainFrame();
	if (pMainFrame != NULL)
	{
		return pMainFrame->m_pTextV;
	}
	return NULL;
}

CAccountView* GetAccountView()
{
	CMainFrame* pMainFrame = GetMainFrame();
	if (pMainFrame != NULL)
	{
		return pMainFrame->m_pAcntV;
	}
	return NULL;
}

CFolderView* GetFolderView()
{
	CMainFrame* pMainFrame = GetMainFrame();
	if (pMainFrame != NULL)
	{
		return pMainFrame->m_pTreeV;
	}
	return NULL;
}

// JgAJEgԂ
LPCTSTR WINAPI PA_GetCurrentAccount()
{
	CAccountView* pAccountView = GetAccountView();
	if (pAccountView != NULL)
	{
		return pAccountView->GetCurrentAccountName();
	}
	return NULL_STRING;
}

// JgtH_[pXԂ
LPCTSTR WINAPI PA_GetCurrentFolderPath()
{
	static CString path;
	path = _T("");
	CFolderView* pFolderView = GetFolderView();
	if (pFolderView != NULL)
	{
		HTREEITEM hTreeItem = pFolderView->GetTreeCtrl().GetSelectedItem();
		path = pFolderView->GetItemPath(hTreeItem);
		if (path != _T(""))
		{
			path = PA_GetAppPath() + path;
		}
	}
	return path;
}

// JgtH_[Ԃ
LPCTSTR WINAPI PA_GetCurrentFolderName()
{
	static CString name;
	name = _T("");
	CFolderView* pFolderView = GetFolderView();
	if (pFolderView != NULL)
	{
		name = pFolderView->GetSelectedItemName();
	}
	return name;
}

// CEBhẼnhԂ
HWND WINAPI PA_GetWindowHandle(const POCHY_WINDOW_TYPE windowType)
{
	HWND hWnd = NULL;

	CMainFrame* pMainFrame = GetMainFrame();
	if (pMainFrame != NULL)
	{
		CWnd* pTempWindow = NULL;

		switch (windowType)
		{
		case PW_MAIN_FRAME:
			pTempWindow = pMainFrame;
			break;
		case PW_SUMMARY_VIEW:
			pTempWindow = pMainFrame->m_pListV;
			break;
		case PW_ACCOUNT_VIEW:
			pTempWindow = pMainFrame->m_pAcntV;
			break;
		case PW_FOLDER_VIEW:
			pTempWindow = pMainFrame->m_pTreeV;
			break;
		case PW_TEXT_VIEW:
			pTempWindow = pMainFrame->m_pTextV;
			break;
		case PW_HEADER_VIEW:
			pTempWindow = pMainFrame->m_pHeadV;
			break;
		case PW_MULTIPART_VIEW:
			pTempWindow = pMainFrame->m_pMultiV;
			break;

		case PW_DRAFT_FRAME:
		case PW_ADDRESS_VIEW:
		case PW_MAIL_EDIT_VIEW:
		case PW_ATTACHED_FILE_VIEW:
			// PA_GetDraftWindowHandle() ŃT|[g
			assert(false);
			break;
		}

		if (pTempWindow != NULL)
		{
			hWnd = pTempWindow->GetSafeHwnd();
		}
	}

	return hWnd;
}

// htgEBhẼnhԂ
HWND WINAPI PA_GetDraftWindowHandle(const HWND hDraftFrame, const POCHY_WINDOW_TYPE windowType)
{
	HWND hWnd = NULL;

	CPochyApp* pPochyApp = (CPochyApp*)::AfxGetApp();
	if (pPochyApp != NULL)
	{
		CDraftFrame* pDraftFrame = NULL;
		int i;
		for (i = 0; i < pPochyApp->m_draft_array.GetSize(); i++)
		{
			if (pPochyApp->m_draft_array.GetAt(i)->GetSafeHwnd() == hDraftFrame)
			{
				pDraftFrame = pPochyApp->m_draft_array.GetAt(i);
			}
		}
		if (pDraftFrame != NULL)
		{
			CWnd* pTempWindow = NULL;

			switch (windowType)
			{
			case PW_MAIN_FRAME:
			case PW_SUMMARY_VIEW:
			case PW_ACCOUNT_VIEW:
			case PW_FOLDER_VIEW:
			case PW_TEXT_VIEW:
			case PW_HEADER_VIEW:
			case PW_MULTIPART_VIEW:
				// PA_GetWindowHandle() ŃT|[g
				assert(false);
				break;

			case PW_DRAFT_FRAME:
				pTempWindow = pDraftFrame;
				break;
			case PW_ADDRESS_VIEW:
				pTempWindow = pDraftFrame->m_pAddrsV;
				break;
			case PW_MAIL_EDIT_VIEW:
				pTempWindow = pDraftFrame->m_pEditV;
				break;
			case PW_ATTACHED_FILE_VIEW:
				pTempWindow = pDraftFrame->m_pListV2;
				break;
			}

			if (pTempWindow != NULL)
			{
				hWnd = pTempWindow->GetSafeHwnd();
			}
		}
	}

	return hWnd;
}

// wb_[i[̂ɕKvȃoCgԂBI[ NULL ܂ށB
int WINAPI PA_GetHeaderLength()
{
	int nLength = 0;

	CTextView* pTextView = GetTextView();
	if (pTextView != NULL)
	{
//		nLength = pTextView->GetCurrentHeader().GetLength() + 1;
		nLength = pTextView->m_md.m_hi.GetAllDecoded().GetLength() + 1;
	}

	return nLength;
}

// wb_[擾Bi[oCgԂBI[ NULL ܂ށB
int WINAPI PA_GetHeader(LPTSTR lpszString, int nMaxCount)
{
	int nLength = 0;

	CTextView* pTextView = GetTextView();
	if (lpszString != NULL && pTextView != NULL)
	{
//		CString strHeader = pTextView->GetCurrentHeader();
		CString strHeader = pTextView->m_md.m_hi.GetAllDecoded();
		_tcsncpy(lpszString, strHeader, nMaxCount);
		lpszString[nMaxCount - 1] = _T('\0');
		nLength = _tcslen(lpszString) + 1;
	}

	return nLength;
}

// {fBi[̂ɕKvȃoCgԂBI[ NULL ܂ށB
int WINAPI PA_GetBodyLength()
{
	int nLength = 0;

	CTextView* pTextView = GetTextView();
	if (pTextView != NULL)
	{
		nLength = pTextView->GetCurrentBody().GetLength() + 1;
	}

	return nLength;
}

// {fB[擾Bi[oCgԂBI[ NULL ܂ށB
int WINAPI PA_GetBody(LPTSTR lpszString, int nMaxCount)
{
	int nLength = 0;

	CTextView* pTextView = GetTextView();
	if (lpszString != NULL && pTextView != NULL)
	{
		CString strBody = pTextView->GetCurrentBody();
		_tcsncpy(lpszString, strBody, nMaxCount);
		lpszString[nMaxCount - 1] = _T('\0');
		nLength = _tcslen(lpszString) + 1;
	}

	return nLength;
}

// ݕ\Ă郁[̃tpXԂ
LPCTSTR WINAPI PA_GetCurrentMailPath()
{
	CTextView* pTextView = GetTextView();
	if (pTextView != NULL)
	{
		return pTextView->GetCurrentPath();
	}
	return NULL_STRING;
}

// Ɋ֘AtꂽbZ[WƃR[obN֐o^
UINT WINAPI PA_RegisterCallback(LPCTSTR lpszString, POCHY_MENU_CALLBACK callback)
{
	UINT nID = 0;

	CMainFrame* pMainFrame = GetMainFrame();
	if (pMainFrame != NULL)
	{
		nID = ::RegisterWindowMessage(lpszString);
		if (nID != 0)
		{
			pMainFrame->AddMenuCallback(nID, callback);
		}
	}
	return nID;
}

// vOCj[Ƀj[ڂǉ
UINT WINAPI PA_AppendMenu(LPCTSTR lpszMenuName, POCHY_MENU_CALLBACK callback)
{
	UINT nID = 0;

	if (lpszMenuName != NULL)
	{
		CMainFrame* pMainFrame = GetMainFrame();
		if (pMainFrame != NULL)
		{
			CMenu* pMenu = pMainFrame->GetMenu();
			if (pMenu != NULL)
			{
				CMenu* pSubMenu = NULL;
				for (UINT i = 0; i < pMenu->GetMenuItemCount(); i++)
				{
					CMenu* pTempMenu = pMenu->GetSubMenu(i);
					if (pTempMenu != NULL && pTempMenu->GetMenuItemID(0) == ID_SHOW_PLUGIN_LIST)
					{
						pSubMenu = pTempMenu;
						break;
					}
				}
				if (pSubMenu != NULL)
				{
					nID = PA_RegisterCallback(lpszMenuName, callback);
					if (nID != 0)
					{
						if (pSubMenu->AppendMenu(MF_STRING, nID, lpszMenuName) == 0)
						{
							nID = 0;
						}
					}
				}
			}
		}
	}
	return nID;
}

// Xe[^Xo[ɕZbg
// lpszAccountName ŃAJEgƂɕʂ̃bZ[W
// lpszAccountName  "" w肷ƋʃbZ[W
void WINAPI PA_SetStatusBarText(LPCTSTR lpszAccountName, LPCTSTR lpszText)
{
	if (lpszText != NULL)
	{
		CMainFrame* pMainFrame = GetMainFrame();
		if (pMainFrame != NULL)
		{
			if (lpszAccountName != NULL && lstrlen(lpszAccountName) > 0)
			{
				CAccountView* pAccountView = GetAccountView();
				if (pAccountView != NULL)
				{
					pAccountView->SetStatusBarText(lpszText, lpszAccountName);
				}
			}
			else
			{
				pMainFrame->SetStatusBarText(0, lpszText);
			}
		}
	}
}

// Pochy API ̃o[WԂ
DWORD WINAPI PA_GetAPIVersion()
{
	// Pochy API o[W
	//
	// 4oCgŏʂ\ ( 0)AW[o[WA}Ci[o[WArW̏
	// ) 0x00030507 = version 3.5.07
	//
	// W[o[W͏ʌ݊ȂȂƂ (ÂgȂȂƂ)
	// }Ci[o[W͐V API R[obNǉꂽƂ
	// rW̓oOCȂǂŃC^[tF[X̕ύXsȂƂ
	// ύX\ł (AKȂƂ͌Ȃ)
	return POCHY_API_VERSION;
}
