<?php
/*
This file has been generated by the Sabai scaffold script. Do not edit this file directly.
If you need to customize the class, use the following file:
pluginsy/Xigg/Model/CommentGateway.php
*/
require_once 'Sabai/Model/TreeGateway.php';

abstract class Plugg_Xigg_Model_Base_CommentGateway extends Sabai_Model_TreeGateway
{
    public function getName()
    {
        return 'comment';
    }

    public function getFields()
    {
        return array('comment_id' => Sabai_Model::KEY_TYPE_INT, 'comment_created' => Sabai_Model::KEY_TYPE_INT, 'comment_updated' => Sabai_Model::KEY_TYPE_INT, 'comment_title' => Sabai_Model::KEY_TYPE_VARCHAR, 'comment_body_filter_id' => Sabai_Model::KEY_TYPE_INT, 'comment_body' => Sabai_Model::KEY_TYPE_TEXT, 'comment_body_html' => Sabai_Model::KEY_TYPE_TEXT, 'comment_allow_edit' => Sabai_Model::KEY_TYPE_INT, 'comment_node_id' => Sabai_Model::KEY_TYPE_INT_NULL, 'comment_parent' => Sabai_Model::KEY_TYPE_INT_NULL, 'comment_userid' => Sabai_Model::KEY_TYPE_VARCHAR);
    }
    public function getSortFields()
    {
        return array('comment_id' => Sabai_Model::KEY_TYPE_INT, 'comment_created' => Sabai_Model::KEY_TYPE_INT, 'comment_updated' => Sabai_Model::KEY_TYPE_INT, 'comment_title' => Sabai_Model::KEY_TYPE_VARCHAR, 'comment_body_filter_id' => Sabai_Model::KEY_TYPE_INT, 'comment_body' => Sabai_Model::KEY_TYPE_TEXT, 'comment_body_html' => Sabai_Model::KEY_TYPE_TEXT, 'comment_allow_edit' => Sabai_Model::KEY_TYPE_INT, 'comment_node_id' => Sabai_Model::KEY_TYPE_INT_NULL, 'comment_parent' => Sabai_Model::KEY_TYPE_INT_NULL, 'comment_userid' => Sabai_Model::KEY_TYPE_VARCHAR, 't1.tree_left' => Sabai_Model::KEY_TYPE_INT, 't1.tree_right' => Sabai_Model::KEY_TYPE_INT);
    }

    protected function _getSelectByIdQuery($id, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t.', $fields);
        return sprintf('SELECT t.%s, t1.tree_left, t1.tree_right FROM %scomment t INNER JOIN %2$scomment_tree t1 ON t1.tree_id = t.comment_id WHERE comment_id = %d', $fields, $this->_db->getResourcePrefix(), $id);
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t.', $fields);
        return sprintf('SELECT t.%1$s, t1.tree_left, t1.tree_right FROM %2$scomment t INNER JOIN %2$scomment_tree t1 ON t1.tree_id = t.comment_id WHERE %3$s', $fields, $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getInsertQuery(array $values)
    {
        $values['comment_created'] = time();
        $values['comment_updated'] = 0;
        $values['comment_node_id'] = !empty($values['comment_node_id']) ? intval($values['comment_node_id']) : 'NULL';
        $values['comment_parent'] = !empty($values['comment_parent']) ? intval($values['comment_parent']) : 'NULL';
        return sprintf("INSERT INTO %scomment(comment_created, comment_updated, comment_title, comment_body_filter_id, comment_body, comment_body_html, comment_allow_edit, comment_node_id, comment_parent, comment_userid) VALUES(%d, %d, %s, %d, %s, %s, %d, %s, %s, %s)", $this->_db->getResourcePrefix(), $values['comment_created'], $values['comment_updated'], $this->_db->escapeString($values['comment_title']), $values['comment_body_filter_id'], $this->_db->escapeString($values['comment_body']), $this->_db->escapeString($values['comment_body_html']), $values['comment_allow_edit'], $values['comment_node_id'], $values['comment_parent'], $this->_db->escapeString($values['comment_userid']));
    }

    protected function _getUpdateQuery($id, array $values)
    {
        $values['comment_node_id'] = !empty($values['comment_node_id']) ? intval($values['comment_node_id']) : 'NULL';
        $values['comment_parent'] = !empty($values['comment_parent']) ? intval($values['comment_parent']) : 'NULL';
        $last_update = $values['comment_updated'];
        $values['comment_updated'] = time();
        return sprintf("UPDATE %scomment SET comment_updated = %d, comment_title = %s, comment_body_filter_id = %d, comment_body = %s, comment_body_html = %s, comment_allow_edit = %d, comment_node_id = %s, comment_parent = %s, comment_userid = %s WHERE comment_id = %d AND comment_updated = %d", $this->_db->getResourcePrefix(), $values['comment_updated'], $this->_db->escapeString($values['comment_title']), $values['comment_body_filter_id'], $this->_db->escapeString($values['comment_body']), $this->_db->escapeString($values['comment_body_html']), $values['comment_allow_edit'], $values['comment_node_id'], $values['comment_parent'], $this->_db->escapeString($values['comment_userid']), $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$scomment WHERE comment_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, array $sets)
    {
        $sets['comment_updated'] = 'comment_updated=' . time();
        return sprintf('UPDATE %scomment SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(',', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE FROM %1$scomment WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$scomment WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    public function selectByIdFromMainTable($id, array $fields = array())
    {
        $fields = empty($fields) ? '*' : implode(',', $fields);
        $sql = sprintf('SELECT %s FROM %scomment WHERE comment_id = %d', $fields, $this->_db->getResourcePrefix(), $id);
        return $this->_db->query($sql);
    }

    protected function _getSelectDescendantsQuery($id, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t3.', $fields);
        return sprintf('SELECT t3.%3$s, t1.tree_left, t1.tree_right FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right INNER JOIN %1$scomment t3 ON t1.tree_id = t3.comment_id WHERE t2.tree_id = %2$d AND t1.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getSelectDescendantsAsTreeQuery($id, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t3.', $fields);
        return sprintf('SELECT t3.%3$s, t1.tree_left, t1.tree_right, levels.level FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right INNER JOIN %1$scomment t3 ON t1.tree_id = t3.comment_id INNER JOIN (SELECT t4.tree_id, COUNT(*) AS level FROM %1$scomment_tree t4 INNER JOIN %1$scomment_tree t5 ON t4.tree_left BETWEEN t5.tree_left AND t5.tree_right GROUP BY t4.tree_id) AS levels ON t3.comment_id = levels.tree_id WHERE t2.tree_id = %2$d AND t1.tree_id <> %2$d GROUP BY comment_id', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getCountDescendantsQuery($id)
    {
        return sprintf('SELECT COUNT(*) FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t2.tree_id = %2$d AND t1.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getCountDescendantsByIdsQuery($ids)
    {
        return sprintf('SELECT t2.tree_id, COUNT(*) - 1 FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t2.tree_id IN(%2$s) GROUP BY t2.tree_id', $this->_db->getResourcePrefix(), implode(',', $ids));
    }

    protected function _getSelectParentsQuery($id, array $fields)
    {
        $fields = empty($fields) ? '*' : implode(', t3.', $fields);
        return sprintf('SELECT t3.%3$s, t2.tree_left, t2.tree_right FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right INNER JOIN %1$scomment t3 ON t2.tree_id = t3.comment_id WHERE t1.tree_id = %2$d AND t2.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id, $fields);
    }

    protected function _getCountParentsQuery($id)
    {
        return sprintf('SELECT COUNT(*) FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t1.tree_id = %2$d AND t2.tree_id <> %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getCountParentsByIdsQuery($ids)
    {
        return sprintf('SELECT t1.tree_id, COUNT(*) - 1 FROM %1$scomment_tree t1 INNER JOIN %1$scomment_tree t2 ON t1.tree_left BETWEEN t2.tree_left AND t2.tree_right WHERE t1.tree_id IN(%2$s) GROUP BY t1.tree_id', $this->_db->getResourcePrefix(), implode(',', $ids));
    }

    protected function _afterInsertTrigger1($id, array $new)
    {
        if (!empty($new['comment_parent'])) {
            $sql = sprintf('SELECT tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $new['comment_parent']);
            if ($rs = $this->_db->query($sql)) {
                $value_right = $rs->fetchSingle();
                $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left + 2 WHERE tree_left > %d', $this->_db->getResourcePrefix(), $value_right));
                $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right + 2 WHERE tree_right >= %d', $this->_db->getResourcePrefix(), $value_right));
                $this->_db->exec(sprintf('INSERT INTO %scomment_tree(tree_id, tree_left, tree_right) VALUES (%d, %d, %d)', $this->_db->getResourcePrefix(), $new['comment_id'], $value_right, $value_right + 1));
            }
        } else {
            $sql = sprintf('SELECT MAX(tree_right) FROM %scomment_tree', $this->_db->getResourcePrefix());
            if ($rs = $this->_db->query($sql)) {
                $value_right = $rs->fetchSingle();
                $this->_db->exec(sprintf('INSERT INTO %scomment_tree(tree_id, tree_left, tree_right) VALUES (%d, %d, %d)', $this->_db->getResourcePrefix(), $new['comment_id'], $value_right + 1, $value_right + 2));
            }
        }
    }

    protected function _beforeDeleteTrigger1($id, array $old)
    {
        $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
        if (!$rs = $this->_db->query($sql)) {
            return false;
        }
        list($value_left, $value_right) = $rs->fetchRow();
        if ($value_right - $value_left > 1) {
            // Cannot remove entity with child entities
            return false;
        }
        return true;
    }

    protected function _afterDeleteTrigger1($id, array $old)
    {
        $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
        if ($rs = $this->_db->query($sql)) {
            list($value_left, $value_right) = $rs->fetchRow();
            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left - 2 WHERE tree_left > %d', $this->_db->getResourcePrefix(), $value_left));
            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right - 2 WHERE tree_right > %d', $this->_db->getResourcePrefix(), $value_right));
            $this->_db->exec(sprintf('DELETE FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']));
        }
    }

    protected function _beforeUpdateTrigger1($id, array $new, array $old)
    {
        if (!empty($new['comment_parent'])) {
            if ($new['comment_parent'] == $new['comment_id']) {
                // Cannot assign itself as the parent entity
                return false;
            }
            $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
            if (!$rs = $this->_db->query($sql)) {
                return false;
            }
            list($old_left, $old_right) = $rs->fetchRow();
            $sql = sprintf('SELECT tree_left FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $new['comment_parent']);
            if (!$rs = $this->_db->query($sql)) {
                return false;
            }
            $new_parent_left = $rs->fetchSingle();
            if ($new_parent_left > $old_left && $new_parent_left < $old_right) {
                // Cannot assign descendant as the parent entity
                return false;
            }
        }
        return true;
    }

    protected function _afterUpdateTrigger1($id, array $new, array $old)
    {
        if (!empty($new['comment_parent'])) {
            if (empty($old['comment_parent']) || $new['comment_parent'] != $old['comment_parent']) {
                $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
                if ($rs = $this->_db->query($sql)) {
                    list($value_left, $value_right) = $rs->fetchRow();
                    $sql = sprintf('SELECT MAX(tree_right) + 1 FROM %scomment_tree', $this->_db->getResourcePrefix());
                    if ($rs = $this->_db->query($sql)) {
                        $temp_left = $rs->fetchSingle();
                        $value_between = $value_right - $value_left + 1;
                        $this->_db->exec(sprintf('UPDATE %4$scomment_tree SET tree_left = tree_left + %1$d - %2$d, tree_right = tree_right + %1$d - %2$d WHERE tree_left BETWEEN %2$d AND %3$d', $temp_left, $value_left, $value_right, $this->_db->getResourcePrefix()));
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left - %d WHERE tree_left > %d AND tree_right < %d', $this->_db->getResourcePrefix(), $value_between, $value_right, $temp_left));
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right - %d WHERE tree_right > %d AND tree_right < %d', $this->_db->getResourcePrefix(), $value_between, $value_right, $temp_left));
                        $sql = sprintf('SELECT tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $new['comment_parent']);
                        if ($rs = $this->_db->query($sql)) {
                            $new_parent_right = $rs->fetchSingle();
                            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left + %d WHERE tree_left > %d AND tree_left < %d', $this->_db->getResourcePrefix(), $value_between, $new_parent_right, $temp_left));
                            $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right + %d WHERE tree_right >= %d AND tree_left < %d', $this->_db->getResourcePrefix(), $value_between, $new_parent_right, $temp_left));
                            $value_diff = $new_parent_right - $temp_left;
                            $this->_db->exec(sprintf('UPDATE %3$scomment_tree SET tree_left = tree_left + %1$d, tree_right = tree_right + %1$d WHERE tree_left >= %2$d', $value_diff, $temp_left, $this->_db->getResourcePrefix()));
                        }
                    }
                }
            }
        } else {
            if (!empty($old['comment_parent'])) {
                $sql = sprintf('SELECT tree_left, tree_right FROM %scomment_tree WHERE tree_id = %d', $this->_db->getResourcePrefix(), $old['comment_id']);
                if ($rs = $this->_db->query($sql)) {
                    list($value_left, $value_right) = $rs->fetchRow();
                    $sql = sprintf('SELECT MAX(tree_right) + 1 FROM %scomment_tree', $this->_db->getResourcePrefix());
                    if ($rs = $this->_db->query($sql)) {
                        $temp_left = $rs->fetchSingle();
                        $value_diff = $temp_left - $value_left;
                        $this->_db->exec(sprintf('UPDATE %4$scomment_tree SET tree_left = tree_left + %1$d, tree_right = tree_right + %1$d WHERE tree_left BETWEEN %2$d AND %3$d', $value_diff, $value_left, $value_right, $this->_db->getResourcePrefix()));
                        $value_between = $value_right - $value_left + 1;
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_left = tree_left - %d WHERE tree_left > %d', $this->_db->getResourcePrefix(), $value_between, $value_right));
                        $this->_db->exec(sprintf('UPDATE %scomment_tree SET tree_right = tree_right - %d WHERE tree_right > %d', $this->_db->getResourcePrefix(), $value_between, $value_right));
                    }
                }
            }
        }
    }

    protected function _afterInsertTrigger2($id, array $new)
    {
        if (!empty($new['comment_node_id'])) {
            $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count + 1, node_comment_last = %d, node_comment_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $id, $new['comment_created'], $new['comment_node_id']));
        }
    }

    protected function _afterDeleteTrigger2($id, array $old)
    {
        if (!empty($old['comment_node_id'])) {
            $sql = sprintf('SELECT comment_id, comment_created FROM %scomment WHERE comment_node_id = %d ORDER BY comment_created DESC', $this->_db->getResourcePrefix(), $old['comment_node_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count - 1, node_comment_last = %d, node_comment_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $row['comment_id'], $row['comment_created'], $old['comment_node_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count - 1, node_comment_last = 0, node_comment_lasttime = node_created WHERE node_id = %d', $this->_db->getResourcePrefix(), $old['comment_node_id']));
            }
        }
    }

    protected function _afterUpdateTrigger2($id, array $new, array $old)
    {
        if (empty($old['comment_node_id']) && !empty($new['comment_node_id'])) {
            $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count + 1, node_comment_last = %d, node_comment_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $id, $new['comment_created'], $new['comment_node_id']));
        } elseif (!empty($old['comment_node_id']) && empty($new['comment_node_id'])) {
            $sql = sprintf('SELECT comment_id, comment_created FROM %scomment WHERE comment_node_id = %d ORDER BY comment_created DESC', $this->_db->getResourcePrefix(), $old['comment_node_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count - 1, node_comment_last = %d, node_comment_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $row['comment_id'], $row['comment_created'], $old['comment_node_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count - 1, node_comment_last = 0, node_comment_lasttime = node_created WHERE node_id = %d', $this->_db->getResourcePrefix(), $old['comment_node_id']));
            }
        } elseif ($old['comment_node_id'] != $new['comment_node_id']) {
            $sql = sprintf('SELECT comment_id, comment_created FROM %scomment WHERE comment_node_id = %d ORDER BY comment_created DESC', $this->_db->getResourcePrefix(), $old['comment_node_id']);
            if (($rs = $this->_db->query($sql, 1, 0)) && ($rs->rowCount() > 0)) {
                $row = $rs->fetchAssoc();
                $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count - 1, node_comment_last = %d, node_comment_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $row['comment_id'], $row['comment_created'], $old['comment_node_id']));
            } else {
                $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count - 1, node_comment_last = 0, node_comment_lasttime = node_created WHERE node_id = %d', $this->_db->getResourcePrefix(), $old['comment_node_id']));
            }
            $this->_db->exec(sprintf('UPDATE %snode SET node_comment_count = node_comment_count + 1, node_comment_last = %d, node_comment_lasttime = %d WHERE node_id = %d', $this->_db->getResourcePrefix(), $id, $new['comment_created'], $new['comment_node_id']));
        }
    }

    protected function _afterInsertTrigger($id, array $new)
    {
        $this->_afterInsertTrigger1($id, $new);
        $this->_afterInsertTrigger2($id, $new);
    }

    protected function _beforeUpdateTrigger($id, array $new, array $old)
    {
        if (!$this->_beforeUpdateTrigger1($id, $new, $old)) return false;
        return true;
    }

    protected function _afterUpdateTrigger($id, array $new, array $old)
    {
        $this->_afterUpdateTrigger1($id, $new, $old);
        $this->_afterUpdateTrigger2($id, $new, $old);
    }

    protected function _beforeDeleteTrigger($id, array $old)
    {
        if (!$this->_beforeDeleteTrigger1($id, $old)) return false;
        return true;
    }

    protected function _afterDeleteTrigger($id, array $old)
    {
        $this->_afterDeleteTrigger1($id, $old);
        $this->_afterDeleteTrigger2($id, $old);
    }
}