<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_ShowCommentReplyForm extends Plugg_FormController
{
    private $_comment;
    private $_reply;

    protected function _init(Sabai_Application_Context $context)
    {
        if (!$comment_id = $context->request->getAsInt('comment_id', false)) {
            return false;
        }
        if (!$this->_comment = $context->plugin->getModel()->Comment->fetchById($comment_id)) {
            return false;
        }
        $node = $this->_comment->Node;
        if (!$node->allow_comments || !$node->isReadable($context->user)) {
            $context->response->setError($context->plugin->_('Comments not allowed for this news article'), array(
                'path' => '/' . $node->getId(),
                'params' => array('comment_id' => $this->_comment->getId()),
                'fragment' => 'comment' . $this->_comment->getId()
            ));
            return false;
        }
        $this->_reply = $node->createComment();

        return true;
    }

    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowCommentForm', array($context, $form, /*$isReply*/ true));
        $context->response->setPageInfo($this->_comment->Node->title, array('path' => '/' . $this->_comment->Node->getId()));
        $context->response->setPageInfo($context->plugin->_('Submit comment'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_reply->toHTMLQuickForm('', $this->url->create(array(
            'path' => '/comment/' . $this->_comment->getId() . '/reply'))
        );
        $form->removeElements(array('Node', 'body_html', 'allow_edit'));
        $comment_title = trim($this->_comment->title);
        $form->setDefaults(array(
            'title' => !preg_match('/^Re:/i', $comment_title) ? 'Re: ' . $comment_title : $comment_title,
            'body' => "\n\n" . strtr("\n" . $this->_comment->body, array("\n>" => "\n>>", "\n" => "\n> "))
            //'body' => sprintf('<blockquote cite="%s" title="%s">%s</blockquote>', $this->url->create(array('path' => '/comment/' . $this->_comment->getId())), h($comment_title), "\n" . $this->_comment->body . "\n"),
        ));
        return $form;
    }
}