<?php
class Plugg_Xigg_Main_Node_ShowTrackbacks extends Sabai_Application_Controller
{
    protected function _doExecute(Sabai_Application_Context $context)
    {
        if ((!$node = $this->_parent->getNodeById($context, 'node_id')) ||
            !$node->isReadable($context->user)
        ) {
            $context->response->setError($context->plugin->_('Invalid request'));
            return;
        }
        $trackback_view = $context->request->getAsStr('trackback_view', 'newest');
        $perpage = $context->plugin->getParam('numberOfTrackbacksOnPage');
        if ($trackback_view == 'oldest') {
            $pages = $node->paginateTrackbacks($perpage, 'trackback_created', 'ASC');
        } else {
            $trackback_view = 'newest';
            $pages = $node->paginateTrackbacks($perpage, 'trackback_created', 'DESC');
        }
        $page = $pages->getValidPage($context->request->getAsInt('trackback_page', 1));
        $context->response->setVars(array(
            'node'            => $node,
            'trackback_pages' => $pages,
            'trackback_page'  => $page,
            'trackback_view'  => $trackback_view)
        );
    }
}