<?php
class Plugg_Xigg_Main_Node extends Plugg_RoutingController
{   
    function __construct()
    {
        parent::__construct('ShowNode', 'Plugg_Xigg_Main_Node_', dirname(__FILE__) . '/Node');
        $this->addControllerFilter(array(
            'DeleteNodeForm',
            'EditNodeForm',
            'PublishNodeForm'
        ), 'isAuthenticated');
        $this->addControllerFilter(array('ShowComments'), 'isCommentFeatureEnabled');
        $this->addControllerFilter(array(
            'ShowTrackbacks',
            'PostTrackback'
        ), 'isTrackbackFeatureEnabled');
        $this->addControllerFilter(array(
            'ShowVotes',
            'ShowVoteForm',
            'SubmitVote'
        ), 'isVotingFeatureEnabled');
        $this->addControllerFilter(array(
            'ShowCommentForm',
            'SubmitCommentForm'
        ), 'isSubmitCommentAllowed');
        $this->addControllerFilter(array(
            'ShowVoteForm',
            'SubmitVote'
        ), 'isSubmitVoteAllowed');
    }

    function _doGetRoutes(Sabai_Application_Context $context)
    {
        return array(
            'votes' => array(
                'controller'   => 'ShowVotes',
                'requirements' => array(':node_id' => '\d+')
            ),
            'voteform' => array(
                'controller'   => 'ShowVoteForm',
                'requirements' => array(':node_id' => '\d+')
            ),
            'vote' => array(
                'controller'   => 'SubmitVote',
                'requirements' => array(':node_id' => '\d+')
            ),
            'comments' => array(
                'controller'   => 'ShowComments',
                'requirements' => array(':node_id' => '\d+')
            ),
            'commentform' => array(
                'controller'   => 'ShowCommentForm',
                'requirements' => array(':node_id' => '\d+')
            ),
            'comment' => array(
                'controller'   => 'SubmitCommentForm',
                'requirements' => array(':node_id' => '\d+')
            ),
            'trackbacks' => array(
                'controller'   => 'ShowTrackbacks',
                'requirements' => array(':node_id' => '\d+')
            ),
            'publish' => array(
                'controller'   => 'PublishNodeForm',
                'requirements' => array(':node_id' => '\d+')
            ),
            'edit' => array(
                'controller'   => 'EditNodeForm',
                'requirements' => array(':node_id' => '\d+')
            ),
            'delete' => array(
                'controller'   => 'DeleteNodeForm',
                'requirements' => array(':node_id' => '\d+')
            ),
            'trackback' => array(
                'controller'   => 'PostTrackback',
                'requirements' => array(':node_id' => '\d+')
            ),
        );
    }
}