<?php
require_once 'Plugg/FormController.php';

class Plugg_Xigg_Main_DeleteTrackbackForm extends Plugg_FormController 
{
    private $_trackback;

    protected function _init(Sabai_Application_Context $context)
    {
        $this->_confirmable = false;
        
        if (!$trackback_id = $context->request->getAsInt('trackback_id')) {
            return false;
        }
        if (!$this->_trackback = $context->plugin->getModel()->Trackback->fetchById($trackback_id)) {
            return false;
        }
        if (!$context->user->hasPermission('xigg trackback delete')) {
            $context->response->setError($context->plugin->_('Permission denied'), array('path' => '/trackback/' . $trackback_id));
            return false;
        }
        
        return true;
    }
    
    protected function _submitForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->_trackback->markRemoved();
        if ($this->_trackback->commit()) {
            $context->response->setSuccess($context->plugin->_('Trackback updated successfully'), array(
                'path' => '/' . $this->_trackback->Node->getId(),
            ));
            $this->pluginManager->dispatch('XiggDeleteTrackbackSuccess', array($context, $this->_trackback));
            return true;
        }
        
        return false;
    }
    
    protected function _viewForm(Sabai_Application_Context $context, Sabai_HTMLQuickForm $form)
    {
        $this->pluginManager->dispatch('XiggShowDeleteTrackbackForm', array($context, $form));
        $context->response->setPageInfo($this->_trackback->Node->title, array(
            'path' => '/' . $this->_trackback->Node->getId()
        ));
        $context->response->setPageInfo($context->plugin->_('Delete trackback'));
    }

    protected function _getForm(Sabai_Application_Context $context)
    {
        $form = $this->_trackback->toHTMLQuickForm();
        $form->removeElementsAll();
        return $form;
    }
}